#include <iostream>
#include <boost/thread.hpp>
#include <boost/signal.hpp>

class Thread
{
    public:

        Thread(std::string a):arg(a)
        {
            stopped = false;
        }

        ~Thread()
        {
            finish();
        }

        void start()
        {
            boost::thread(boost::bind(&Thread::run_tread,this));
        }

        void stop()
        {
            stopped = true;
        }

        boost::signal<void ()> sig;
        boost::signal<void ()> finish;

        private:

           void run_tread()
            {
                while(!stopped)
                {
                    sig();
                }
            }

           volatile bool stopped;
           std::string arg;
};

class Signal
{
    public :
            Signal()
            {}

        void createThread()
        {
            Thread thread("Work thread");
            thread.sig.connect(boost::bind(&Signal::work_thread,this));
            thread.finish.connect(boost::bind(&Signal::end_thread,this));
            thread.start();
            sleep(2);
            thread.stop();
        }

    private:
        void work_thread(){std::cout << "work thread" << std::endl;}
        void end_thread(){std::cout << "end thread" << std::endl;}
};

int main(int argc, char *argv[])
{
    Signal signal;
    signal.createThread();
    sleep(2);
    return 0;
}
