#include <QtCore>
#include <QtNetwork>

class EchoThread : public QThread {
    Q_OBJECT
public:
    EchoThread(int socketDescriptor, QObject *parent=0);
    void run();
private:
    int m_socketDescriptor;
    QTcpSocket *m_client;
    QHostAddress m_addr;
public slots:
    void onRead();
    void onDisconnect();
    void displayError(QAbstractSocket::SocketError error);
signals:
    void error(QAbstractSocket::SocketError);
};
//-----------------------------------------
class EchoServer : public QTcpServer {
    Q_OBJECT
public:
    EchoServer(QObject *parent=0);
    bool start();
protected:
    void incomingConnection(int socketDescriptor);
    QList<EchoThread*> m_threads;
public slots:
    void removeThread();
};

