#include <iostream>
#include <QtCore>
#include <QtNetwork>

#define STR(s) ((outcodec->fromUnicode(s)).constData())
#define tr  QObject::tr
using namespace std;

int main(int /*argc*/, char ** /*argv*/) {

    QTextCodec *incodec = QTextCodec::codecForName("CP1251");
    QTextCodec *outcodec = QTextCodec::codecForName("CP866");
    QTextCodec::setCodecForTr(incodec);

    QTcpSocket socket;
    QByteArray block;
    QString s;
    char r[80];
    qint64 port;

    cout << STR(tr("\n    :\n"));
    cin >> r;
    s = outcodec->toUnicode(r);

    cout << STR(tr("\n   :\n"));
    cin >> port;
    
    socket.connectToHost(s, port);
    if ( !socket.waitForConnected(5000) ) {
        cout << STR(tr("\n    : %1\n")
                             .arg(socket.errorString()));
        return 1;
    }
    if (!socket.waitForReadyRead(3000)) {
        cout << STR(tr("\n   : %1\n")
                             .arg(socket.errorString()));
        return 2;
    }
    block = socket.readAll();
    s = outcodec->toUnicode(block.data());
    cout << STR(tr("  : %1\n").arg(s));

    cout << STR(tr("\n  :\n"));
    cin >> r;
    s = outcodec->toUnicode(r);

    if (socket.write(incodec->fromUnicode(s)) <= 0){
        cout << STR(tr(
            "\n     : %1\n")
                             .arg(socket.errorString()));
        return 3;
    }

    if (socket.waitForBytesWritten(3000)) 
        cout << STR(tr("  : %1\n")
                             .arg(s));
    else{
        cout << STR(tr("\n   : %1\n")
                             .arg(socket.errorString()));
        return 4;
    }
    
    if (!socket.waitForReadyRead(3000)) {
        cout << STR(tr("\n   : %1\n")
                             .arg(socket.errorString()));
        return 5;
    }
    block = socket.readAll();
    s = outcodec->toUnicode(block.data());
    cout << STR(tr("  : %1\n").arg(s));

    socket.disconnectFromHost();
    cout << STR(tr("  \n"));

    return 0;
}
