#include <QtGui>
#include "pad.h"

Pad::Pad(QMainWindow * parent)
    : QMainWindow(parent), fileName("")
{
}

void Pad::createMain(const QString & param)
{
    load(param); // load file
  //  QSize docSize;

    mainWidg = new QWidget(this);
    setCentralWidget(mainWidg);

    editArea = new QTextEdit(mainWidg);
    editArea->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);

    QWidget *topWidg = new QWidget(mainWidg);
    topWidg->setMinimumHeight(100);
    topWidg->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Preferred);

    QWidget *bottomWidg = new QWidget(mainWidg);
    bottomWidg->setMinimumHeight(100);
    bottomWidg->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Preferred);

    QVBoxLayout *layout = new QVBoxLayout(mainWidg);
    layout->setMargin(2);
    layout->addWidget(topWidg);
    layout->addWidget(editArea);
    layout->addWidget(bottomWidg);

    statusBar()->showMessage("...");

    // build menu
    fileMenu = menuBar()->addMenu(tr("&File"));

    newAct = new QAction(tr("&Open"), this);
    fileMenu->addAction(newAct);

    saveAct = new QAction(tr("Save"), this);
    fileMenu->addAction(saveAct);

    saveAsAct = new QAction(tr("Save as"), this);
    fileMenu->addAction(saveAsAct);

    connect(newAct, SIGNAL(triggered()), this, SLOT(openFile()));
    connect(saveAct, SIGNAL(triggered()), this, SLOT(saveTo()));
    connect(saveAsAct, SIGNAL(triggered()), this, SLOT(saveAs()));

    setMinimumSize(400, 600);
}

void Pad::load(const QString & param)
{
    fileName = param;

    if(param.isEmpty())
    {
        setWindowTitle(QString::fromUtf8("dPad - файл не загружен"));
    }else{

        QString newTitle = "dPad - ";
        newTitle.append(param);
        setWindowTitle(newTitle);

        QFile file(param);

        if (!file.open(QIODevice::ReadOnly))
        {
            QMessageBox::information(this, tr("Unable to open file"),
                file.errorString());
            return;
        }

        QTextStream in(&file);
        QString line = in.readAll();

        editArea->setText(line);
    }
}

void Pad::saveTo()
{
    QFile file(fileName);

    if(!file.open(QIODevice::WriteOnly))
    {
        QMessageBox::information(this, tr("Cant open file to save"),
            file.errorString());
        return;
    }

    QTextStream out(&file);
    out << editArea->toPlainText();
    file.close();
}

void Pad::saveAs()
{

    QString newName = QFileDialog::getSaveFileName(this,
        tr("Save as.."), ".deex", tr("deex Files (*.deex);;All Files (*)"));

    QFile file(newName);

    if(!file.open(QIODevice::WriteOnly))
    {
        QMessageBox::information(this, tr("Unable to open file"),
            file.errorString());
        return;
    }

    QTextStream out(&file);
    out << editArea->toPlainText();
    file.close();
}

void Pad::openFile()
{

    fileName = QFileDialog::getOpenFileName(this, tr("Open File"),
        ".deex", tr("deex Files (*.deex);;All Files (*)"));

    QFile file(fileName);

    if (!file.open(QIODevice::ReadOnly))
    {
        QMessageBox::information(this, tr("Unable to open file"),
            file.errorString());
        return;
    }

    QTextStream in(&file);
    QString line = in.readAll();

    editArea->setText(line);

    QString newTitle = "dPad - ";
    newTitle.append(fileName);
    setWindowTitle(newTitle);

    file.close();
}

void Pad::msg(const QString & text)
{
    QMessageBox::information(this, tr("Error"), text);
}
