#ifndef RECOGNIZER_H
#define RECOGNIZER_H
#include <QtGui/QWidget>
#include <QPixmap>
#include <QPainter>
#include <QBrush>
#include <QImage>
#include <QString>
#include <QPushButton>
#include <QFont>
#include <QMouseEvent>
#include <QPen>
#include <QStringList>
#include <QStringListModel>
#include <QLabel>
namespace Ui {
    class recognizer;
}

class recognizer : public QWidget {
    Q_OBJECT
public:
    recognizer(QWidget *parent = 0);
    ~recognizer();

protected:
    void changeEvent(QEvent *e);
    bool eventFilter(QObject * o, QEvent * e);

private:
    QPixmap * etalonSymbolPixmap;
    QPixmap * etalonPixelsNetPixmap;
    QPixmap * inputSymbolPixmap;
    QPixmap * inputPixelsNetPixmap;
    QPainter * painter;
    QFont font;
    QPoint lastpoint;
    QPen  drawPen;
    QPen defPen;
    QVector <QPushButton *> buttons;
    QStringListModel etalonArrayModel;
    QStringListModel inputArrayModel;
    QStringListModel resultModel;
    QVector <int> etalonArray;
    QVector <int> inputArray;
    int matrix[30][30];
    Ui::recognizer *ui;
    void setConnections();// 
    void getButtons();//   ..
    void drawPixelsNet(QPixmap *pix, QLabel * lab);//  
    void getArray(QImage img,QVector <int> * vec, QStringListModel * strModel);//   
    void drawLetter(QPixmap *pixmap, QString letter);
    static bool cmp (QPair <QString ,double > & first, QPair <QString, double> & second);

public slots :
       void drawLetter();//  ,     
       void clearPixmaps();//    " "
       void clearInputField();//   
       void recognize();//  
       void clearResults();
};

#endif // RECOGNIZER_H
