#include "recognizer.h"
#include "ui_recognizer.h"
#include <QDebug>
#include <QtAlgorithms>

recognizer::recognizer(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::recognizer)
{
    ui->setupUi(this);
   // 
    getButtons();
    //  
    setConnections();
    // 
    painter = new QPainter();
    etalonSymbolPixmap = new QPixmap(ui->etalonSymbol->size());
    etalonPixelsNetPixmap = new QPixmap(ui->etalonPixelsNet->size());
    inputSymbolPixmap = new QPixmap(ui->inputSymbolFiled->size());
    inputPixelsNetPixmap = new QPixmap(ui->inputSymbolPixelsNet->size());
    ui->inputSymbolFiled->installEventFilter(this);
    // 
    font.setFamily("Calibri");
    font.setPointSize(200);
    font.setBold(true);
    // 
    drawPen.setColor(Qt::black);
    drawPen.setCapStyle(Qt::RoundCap);
    drawPen.setBrush(Qt::SolidPattern);
    drawPen.setWidth(30);
    drawPen.setStyle(Qt::SolidLine);
    drawPen.setJoinStyle(Qt::RoundJoin);
    defPen.setCapStyle(Qt::SquareCap);
    defPen.setJoinStyle(Qt::BevelJoin);
    defPen.setWidth(7);
    //  
    ui->etalonArray->setFont(QFont("Calibri",8));
    ui->etalonArray->setSpacing(-2);
    ui->etalonArray->setModel(&etalonArrayModel);
    ui->inputSymbolArray->setFont(QFont("Calibri",8));
    ui->inputSymbolArray->setSpacing(-2);
    ui->inputSymbolArray->setModel(&inputArrayModel);
    ui->resultView->setModel(&resultModel);
    //    
    this->clearPixmaps();
    // 
    this->setFixedSize(891,513);
}

void recognizer::clearPixmaps()
{
    //   
    etalonSymbolPixmap->fill();
    etalonPixelsNetPixmap->fill();
    inputPixelsNetPixmap->fill();
    inputSymbolPixmap->fill();
    //   2 
    painter->begin(etalonPixelsNetPixmap);
    painter->fillRect(etalonPixelsNetPixmap->rect(),QBrush(Qt::gray,Qt::CrossPattern));
    painter->end();
    painter->begin(inputPixelsNetPixmap);
    painter->fillRect(inputPixelsNetPixmap->rect(),QBrush(Qt::gray,Qt::CrossPattern));
    painter->end();
    // 
    ui->etalonSymbol->setPixmap(*etalonSymbolPixmap);
    ui->etalonPixelsNet->setPixmap(*etalonPixelsNetPixmap);
    ui->inputSymbolFiled->setPixmap(*inputSymbolPixmap);
    ui->inputSymbolPixelsNet->setPixmap(*inputPixelsNetPixmap);
}

void recognizer::clearResults()
{
    etalonArrayModel.removeRows(0,etalonArrayModel.rowCount());
    inputArrayModel.removeRows(0,inputArrayModel.rowCount());
    etalonArray.clear();
    inputArray.clear();
    resultModel.removeRows(0,resultModel.rowCount());
}

void recognizer::clearInputField()
{
    //    
    inputSymbolPixmap->fill();
    ui->inputSymbolFiled->setPixmap(*inputSymbolPixmap);
     inputArray.clear();
     inputArrayModel.removeRows(0,inputArrayModel.rowCount());
     inputPixelsNetPixmap->fill();
     painter->begin(inputPixelsNetPixmap);
     painter->fillRect(inputPixelsNetPixmap->rect(),QBrush(Qt::gray,Qt::CrossPattern));
     painter->end();
     ui->inputSymbolPixelsNet->setPixmap(*inputPixelsNetPixmap);
}


void recognizer::drawLetter()
{
    // 
    QString letter ((qobject_cast<QPushButton*>(sender()))->text());
    etalonSymbolPixmap->fill();
    painter->begin(etalonSymbolPixmap);
    painter->setFont(font);
    painter->drawText(etalonSymbolPixmap->rect(),Qt::AlignCenter,letter);
    painter->end();
    ui->etalonSymbol->setPixmap(*etalonSymbolPixmap);
    //  
    getArray(etalonSymbolPixmap->toImage(),&etalonArray,&etalonArrayModel);
    //  
    drawPixelsNet(etalonPixelsNetPixmap,ui->etalonPixelsNet);
}

void recognizer::drawLetter(QPixmap *pixmap,QString letter)
{
    // 
    pixmap->fill();
    painter->begin(pixmap);
    painter->setFont(font);
    painter->drawText(pixmap->rect(),Qt::AlignCenter,letter);
    painter->end();
}

void recognizer::getArray(QImage image, QVector<int> * vec, QStringListModel * strModel=0)
{
    vec->clear();
    QString str;
    QStringList arrayList;
   // 
    for (int i=0;i<30;++i)
         for(int j=0;j<30;++j)
             matrix[i][j]=0;
    //  
    int h=image.height();
    int w=image.width();
    int value = 40;//  
    // ..
    for(int i=0;i<w;++i)
        for(int j=0;j<h;++j)
            matrix[j/8][i/8]+=(image.pixel(i,j)==4278190080UL)? 1 : 0;// , 1  , 0  
    //      
    for(int i = 0; i < 30; i++)
    {
        for(int j = 0; j < 30; j++)
        {
            matrix[i][j] /= value;//  value -    value% 
            if(strModel)
              str.append(QString::number(matrix[i][j]));
                vec->push_back(matrix[i][j]);
        }
        if(strModel)
        {
            arrayList << str;
            str.clear();
        }
    }
    if(strModel)
        strModel->setStringList(arrayList);
}

void recognizer::drawPixelsNet(QPixmap *pixmap, QLabel * lab)
{
        pixmap->fill();
        painter->begin(pixmap);
        painter->fillRect(pixmap->rect(),QBrush(Qt::gray,Qt::CrossPattern));
        painter->setPen(defPen);
        for(int i = 0; i < 30; i++)
        {
            for(int j = 0; j < 30; j++)
                if (matrix[i][j])
                painter->drawLine(j*8,(i+1)*8,j*8,(i+1)*8);
        }
        painter->end();
        lab->setPixmap(*pixmap);
}

void recognizer::recognize()
{
    resultModel.removeRows(0,resultModel.rowCount());
    //    
    getArray(inputSymbolPixmap->toImage(),&inputArray,&inputArrayModel);
    drawPixelsNet(inputPixelsNetPixmap,ui->inputSymbolPixelsNet);
    double diff=0;
    QPixmap bufpixmap(etalonSymbolPixmap->size());
    QVector < QPair < QString, double > > diffVec;//     
    QVector <int>       bufarray;//   ..
    for(int i=0;i<buttons.size();i++)
    {
        diff=0;
        drawLetter(&bufpixmap,buttons[i]->text());
        getArray(bufpixmap.toImage(),&bufarray);
        for(int j=0;j<inputArray.size();++j)
            if (inputArray[j]!=bufarray[j])
                diff++;
//        diff/=3;//.    3   ,    3...
        diff=(diff*100)/900;
        diffVec.push_back(qMakePair(buttons.at(i)->text(),diff));
    }
    qSort(diffVec.begin(), diffVec.end(),cmp);
    diffVec.erase(diffVec.begin()+10,diffVec.end());
    for(int i=0;i<diffVec.size();++i)
        diffVec[i].second=100-diffVec[i].second;
    QString bufstr(", %1  %2%");
    QStringList lst;
    for(int i=0;i<diffVec.size();++i)
    {
        bufstr.replace(QString("%1"),diffVec[i].first);
        bufstr.replace(QString("%2"),QString::number(diffVec[i].second));
        lst << bufstr;
        bufstr=", %1  %2%";
    }
    resultModel.setStringList(lst);
}

bool recognizer::eventFilter(QObject *o, QEvent *e)
{//  
    QMouseEvent me = *(static_cast<QMouseEvent*> (e));
    if (o == ui->inputSymbolFiled)
    {
        if (me.type()== QEvent::MouseButtonPress)
           {
               if(me.button() == Qt::LeftButton)
                {
                   painter->begin(inputSymbolPixmap);
                   painter->setRenderHint(QPainter::HighQualityAntialiasing,true);
                   painter->setPen(drawPen);
                   painter->drawPoint(me.pos());
                   painter->end();
                   lastpoint=me.pos();
                   ui->inputSymbolFiled->setPixmap(*inputSymbolPixmap);
                   return true;
                }
           }else
               if (me.type() == QEvent::MouseMove)
               {
                 painter->begin(inputSymbolPixmap);
                 painter->setRenderHint(QPainter::HighQualityAntialiasing,true);
                 painter->setPen(drawPen);
                 painter->drawLine(lastpoint,me.pos());
                 painter->end();
                 lastpoint=me.pos();
                 ui->inputSymbolFiled->setPixmap(*inputSymbolPixmap);
                 return true;
                }
    }
    return QWidget::eventFilter(o,e);
}

void recognizer::setConnections()
{
    connect(ui->clearButton,SIGNAL(clicked()),this,SLOT(clearPixmaps()));
    connect(ui->clearButton,SIGNAL(clicked()),this,SLOT(clearResults()));
    connect(ui->recognizeButton,SIGNAL(clicked()),this,SLOT(recognize()));
    for(int i=0;i<buttons.size();++i)
    {
        connect(buttons[i],SIGNAL(clicked()),this,SLOT(drawLetter()));
        connect(buttons[i],SIGNAL(clicked()),this,SLOT(clearInputField()));
    }
}

void recognizer::getButtons()
{
    // 
    buttons.push_back(ui->letterButtonA);
    buttons.push_back(ui->letterButtonB);
    buttons.push_back(ui->letterButtonC);
    buttons.push_back(ui->letterButtonD);
    buttons.push_back(ui->letterButtonE);
    buttons.push_back(ui->letterButtonF);
    buttons.push_back(ui->letterButtonG);
    buttons.push_back(ui->letterButtonH);
    buttons.push_back(ui->letterButtonI);
    buttons.push_back(ui->letterButtonJ);
    buttons.push_back(ui->letterButtonK);
    buttons.push_back(ui->letterButtonL);
    buttons.push_back(ui->letterButtonM);
    buttons.push_back(ui->letterButtonN);
    buttons.push_back(ui->letterButtonO);
    buttons.push_back(ui->letterButtonP);
    buttons.push_back(ui->letterButtonQ);
    buttons.push_back(ui->letterButtonR);
    buttons.push_back(ui->letterButtonS);
    buttons.push_back(ui->letterButtonT);
    buttons.push_back(ui->letterButtonU);
    buttons.push_back(ui->letterButtonV);
    buttons.push_back(ui->letterButtonW);
    buttons.push_back(ui->letterButtonX);
    buttons.push_back(ui->letterButtonY);
    buttons.push_back(ui->letterButtonZ);
}

recognizer::~recognizer()
{
    delete ui;
}

void recognizer::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

 bool recognizer::cmp(QPair<QString, double> &first, QPair<QString, double> &second)
{
    return first.second < second.second;
}
