#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QColor>
#include "gnode.h"
#include <QTableWidgetItem>
#include <QMessageBox>
#include <QStack>
#include <QQueue>

QStack <GNode> MySt1;
QStack <GNode> MySt2;
QQueue <GNode> MyQ1;
QQueue <GNode> MyQ2;
QVector < QVector <int> > matrix;

int m,Cost;
MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindowClass)
{
    ui->setupUi(this);
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::on_pushButton_clicked()
{
ui->TableGraf->clear();
m=ui->lineEdit->text().toInt()+1;
ui->in_Box->setMaximum(m-1);
ui->out_Box->setMaximum(m-1);
MySt1.clear();
MySt2.clear();
MyQ1.clear();
MyQ2.clear();
Cost=0;
matrix.clear();
ui->label_Way->setText(" ");
ui->label_Cost->setText(" ");
ui->TableGraf->setColumnCount(ui->lineEdit->text().toInt());
ui->TableGraf->setRowCount(ui->lineEdit->text().toInt());
for (int i=0;i<ui->lineEdit->text().toInt();i++)
    {
        ui->TableGraf->setColumnWidth(i,25);
        ui->TableGraf->setRowHeight(i,25);

    }
ui->TableGraf->horizontalHeader()->setResizeMode(QHeaderView::Fixed);
ui->TableGraf->verticalHeader()->setResizeMode(QHeaderView::Fixed);

matrix.resize(m);
for (int i=0;i<m;i++)
{
    matrix[i].resize(m);
    for (int j=0;j<m;j++)
{
        QTableWidgetItem *DiagonalItem = new QTableWidgetItem(QTableWidgetItem::UserType);
        matrix[i][j]=0;
        if (i==j)
        {
            DiagonalItem->setBackgroundColor(Qt::blue);
            ui->TableGraf->blockSignals(true);
            ui->TableGraf->setItem(i-1,j-1, DiagonalItem);
            ui->TableGraf->blockSignals(false);
        }
    }
}

if(ui->RandomCheck->isChecked())
{int k=1;
    for (int i=1;i<m;i++)
    {
        for (int j=k;j<m;j++)
        {
            if (i!=j)
            {
                if (random()%2!=1)
                {
                    QString RandCost;
                    RandCost.setNum(random()%100);
                    QTableWidgetItem *nwItem = new QTableWidgetItem(QTableWidgetItem::UserType);
                    QTableWidgetItem *nwItemMirrow = new QTableWidgetItem(QTableWidgetItem::UserType);
                    nwItem->setText(RandCost);
                    nwItem->setBackgroundColor(Qt::green);
                    nwItemMirrow->setText(RandCost);
                    nwItemMirrow->setBackgroundColor(Qt::green);
                    ui->TableGraf->blockSignals(true);
                    ui->TableGraf->setItem(i-1,j-1, nwItem);
                    ui->TableGraf->setItem(j-1,i-1, nwItemMirrow);
                    ui->TableGraf->blockSignals(false);
                    matrix[i][j]=RandCost.toInt();
                    matrix[j][i]=RandCost.toInt();
                }
            }

        }
        k++;


    }
}

}





void MainWindow::on_TableGraf_cellChanged(int row, int column)
{
    if (row!=column)
    {
        if (ui->TableGraf->item(row,column)->text()>0)
        {
            ui->TableGraf->item(row,column)->setBackgroundColor(Qt::green);
            QTableWidgetItem *nwItem = new QTableWidgetItem(QTableWidgetItem::UserType);
            nwItem->setText(ui->TableGraf->item(row,column)->text());
            ui->TableGraf->blockSignals(true);
            ui->TableGraf->setItem(column,row, nwItem);
            ui->TableGraf->item(column,row)->setBackgroundColor(Qt::green);
            matrix[row+1][column+1]=ui->TableGraf->item(row,column)->text().toInt();
            matrix[column+1][row+1]=matrix[row+1][column+1];
            ui->TableGraf->blockSignals(false);
        }
        else
        {
          ui->TableGraf->item(row,column)->setText("");
          ui->TableGraf->item(row,column)->setBackgroundColor(Qt::white);
          QTableWidgetItem *ClearItem = new QTableWidgetItem(QTableWidgetItem::UserType);
          ClearItem->setText(ui->TableGraf->item(row,column)->text());
          ClearItem->setBackgroundColor(Qt::white);
          ui->TableGraf->blockSignals(true);
          ui->TableGraf->setItem(column,row, ClearItem);
          matrix[row+1][column+1]=ui->TableGraf->item(row,column)->text().toInt();
          matrix[column+1][row+1]=matrix[row+1][column+1];
          ui->TableGraf->blockSignals(false);
       }

    }
    else
    {
        ui->TableGraf->item(row,column)->setText("");
    }
}





void MainWindow::on_Button_find_clicked()
{
    MySt1.clear();
    MySt2.clear();
    MyQ1.clear();
    MyQ2.clear();
    Cost=0;
    //matrix.clear();
    if (ui->radioDeep->isChecked())
    {
        DeepSearch(ui->in_Box->value(),ui->out_Box->value());
        WayOutDeep(MySt2);
    }

    if (ui->radioBreadth->isChecked())
    {
        BreadthSearch(ui->in_Box->value(),ui->out_Box->value());
        WayOutBreadth(MyQ2);
    }

    if (ui->radioCost->isChecked())
    {
    MinCostSearch(ui->in_Box->value(),ui->out_Box->value());
    WayOutCost(MySt1,Cost);
    }
}

bool FindInStack(QStack <GNode> inStack,GNode ND)
{
    for (int i=0;i<=inStack.count()-1;i++)
    {
        if (inStack.at(i).Numb==ND.Numb)
        {
            return true;
        }
    }
    return false;
}

void MainWindow::WayOutDeep(QStack <GNode> inStack)
{
    GNode Way;
    int nowTop=inStack.top().Way;
    ui->label_Way->setNum(inStack.top().Numb);
    inStack.pop();

    while (!inStack.isEmpty())
    {
        Way=inStack.pop();
        if (Way.Numb==nowTop)
        {
          QString str;
          str.setNum(nowTop);
          ui->label_Way->setText(ui->label_Way->text()+"-"+str);
          nowTop=Way.Way;

        }
    }
}

void MainWindow::WayOutBreadth(QQueue <GNode> inQueue)
{
    GNode Way;
    int NowTop=inQueue.last().Way;
    ui->label_Way->setNum(inQueue.last().Numb);
    inQueue.pop_back();

    while (!inQueue.isEmpty())
    {
        Way=inQueue.last();
        inQueue.pop_back();
        if (Way.Numb==NowTop)
        {
            QString str;
            str.setNum(NowTop);
            ui->label_Way->setText(ui->label_Way->text()+"-"+str);
            NowTop=Way.Way;
        }
    }
}

void MainWindow::WayOutCost(QStack <GNode> inStack,int wayCost)
{
    GNode Way;
    int NowTop=inStack.last().Way;
    ui->label_Way->setNum((inStack.last().Numb));
    inStack.pop_back();
    while (!inStack.isEmpty())
    {
         Way=inStack.last();
         inStack.pop_back();
         if (Way.Numb==NowTop)
         {
            QString str;
            str.setNum(NowTop);
            ui->label_Way->setText(ui->label_Way->text()+"-"+str);
            NowTop=Way.Way;
         }
    }
    ui->label_Cost->setNum(wayCost);
}

void MainWindow::DeepSearch(int inDFS, int outDFS)
{
    GNode ND,NDFound;
    int j;
    bool Flag=true;
    ND.Way=inDFS;
    ND.Numb=inDFS;
    MySt1.push(ND);
    while (Flag)
    {
        try
        {
            if (MySt1.count()>0){
          j=MySt1.top().Numb;
          MySt2.push(MySt1.pop());

        } else
            {
             QMessageBox::critical(this,"Wrong","No way!!!");
           return;
        }
        }

        catch(int ER)
          {
            QMessageBox::critical(this,"Wrong","No way!!!");
           return;

        }

        for (int i=1;i<=outDFS;i++)
        {
            if (matrix[i][j]!=0)
            {
             NDFound.Numb=i;
             NDFound.Way=j;

                     if (!FindInStack(MySt1,NDFound) && !FindInStack(MySt2,NDFound) )
                    {
                    ND.Way=j;
                    ND.Numb=i;
                    MySt1.push(ND);
                    if (i==outDFS)
                    {
                        Flag=false;
                        MySt2.push(ND);
                        QMessageBox::critical(this,"Yahoo","Way is find!!!");
                        break;
                    }
                     }
            }
        }
    }
}


void MainWindow::BreadthSearch(int inBFS,int outBFS)
{
bool Flag=true;
int j;
GNode ND,NDFound;
FoundCL MyFound;
ND.Way=inBFS;
ND.Numb=inBFS;
MyQ1.enqueue(ND);
while (Flag)
{
    try
    {
        if (MyQ1.count()>0)
        {
            j=MyQ1.head().Numb;
            MyQ2.enqueue(MyQ1.dequeue());
        }
        else
        {
               QMessageBox::critical(this,"Wrong","No way!!!");
               return;
        }
    }

     catch(int ER)
     {
       QMessageBox::critical(this,"Wrong","No way!!!");
       break;
     }

     for (int i=1;i<=outBFS;i++)
     {
         if (matrix[i][j]!=0)
         {
             NDFound.Numb=i;
             NDFound.Way=j;
             if (!(MyFound.FoundQueue(MyQ1,NDFound) | MyFound.FoundQueue(MyQ2,NDFound)))
             {
                 ND.Way=j;
                 ND.Numb=i;
                 MyQ1.enqueue(ND);
                 if (i==outBFS)
                 {
                     MyQ2.enqueue(ND);
                     Flag=false;
                     QMessageBox::critical(this,"Yahoo","Way is find!!!");
                     break;
                 }
             }
         }
     }



    }
}

void MainWindow::MinCostSearch(int inMCS, int outMCS)
{
    bool Flag=true;
    int j;
    GNode ND,NDFound;
    ND.Way=inMCS;
    ND.Numb=inMCS;
    ND.Cost=0;
    MyQ1.enqueue(ND);
    FoundCL MyFoundWay;
    while (Flag)
    {
        try
        {
            if (MyQ1.count()>0)
            {
                MyFoundWay.GetMinCost(MyQ1);
                j=MyQ1.head().Numb;
                MySt1.push(MyQ1.head());
                MyQ2.enqueue(MyQ1.dequeue());

            }
            else
            {
                QMessageBox::critical(this,"Wrong","No way!!!");
                return;
            }
        }
         catch(int ER)
        {
             QMessageBox::critical(this,"Wrong","No way!!!");
             break;
         }

         for (int i=1;i<=outMCS;i++)
         {
             if (matrix[i][j]!=0)
             {
                 NDFound.Numb=i;
                 NDFound.Way=j;
                 if (!MyFoundWay.FoundStack(MySt1,NDFound))
                 {
                     ND.Way=j;
                     ND.Numb=i;
                     ND.Cost=matrix[i][j]+MySt1.top().Cost;
                     MyQ1.enqueue(ND);
                 }
             }
         }
         if (MySt1.top().Numb==outMCS)
         {
             Flag=false;
             Cost=MySt1.top().Cost;
             QMessageBox::critical(this,"Yahoo","Way is find!!!");
             break;
         }

    }
}

