#ifndef MyApp_H
#define MyApp_H

#include <QtCore>
#include <qtsingleapplication.h>

#if defined(Q_OS_WIN32)
#include <windows.h>
#include <Dbt.h>
#include <winioctl.h>
#endif

class QRichFileInfo : public QFileInfo
{
private:
    bool onRemovable;
    qint64 driveInfo;
public:
    enum enmDriveInfo {
        DRV_UNKNOWN = 0x0000,
        DRV_NO_ROOT_DIR = 0x0001,
        DRV_REMOVABLE = 0x0002,
        DRV_FIXED = 0x0004,
        DRV_REMOTE = 0x0008,
        DRV_CDROM = 0x0010,
        DRV_RAMDISK = 0x0020,
        BUS_UNKNOWN = 0x0000,
        BUS_SCSI = 0x0100,
        BUS_ATAPI = 0x0200,
        BUS_ATA = 0x0400,
        BUS_1394 = 0x0800,
        BUS_SSA = 0x1000,
        BUS_FIBRE = 0x2000,
        BUS_USB = 0x4000,
        BUS_RAID = 0x8000
    };
private:
public:
    QRichFileInfo(const QString &filePath);
    bool isOnRemovableDevice() const;
    qint64 getDriveInfo() const;
};

class MyApp : public QtSingleApplication
{
    Q_OBJECT

public:
    explicit MyApp(int &argc, char **argv);
    virtual ~MyApp();
protected:
#if defined(Q_OS_WIN32)
    virtual bool winEventFilter(MSG *msg, long *result);
#endif
protected:
#if defined (Q_OS_WIN32)    
    void processDbtConfigChangeCancelled(MSG *msg, long *result);
    void processDbtConfigChanged(MSG *msg, long *result);
    void processDbtDeviceArrival(MSG *msg, long *result);
    void processDbtDeviceQueryRemove(MSG *msg, long *result);
    void processDbtDeviceQueryRemoveFailed(MSG *msg, long *result);
    void processDbtDeviceRemoveComplete(MSG *msg, long *result);
    void processDbtDeviceRemovePending(MSG *msg, long *result);
    void processDbtDeviceTypeSpecific(MSG *msg, long *result);
    void processDbtDevNodesChanged(MSG *msg, long *result);
    void processDbtQueryChangeConfig(MSG *msg, long *result);
    void processDbtUserdefined(MSG *msg, long *result);
    void processDevArrivalBroadcastOEM(DEV_BROADCAST_OEM *dev, long *result);
    void processDevArrivalBroadcastPort(DEV_BROADCAST_PORT *dev, long *result);
    void processDevArrivalBroadcastVolume(DEV_BROADCAST_VOLUME *dev, long *result);
    void processDevArrivalBroadcastHDR(DEV_BROADCAST_HDR *dev, long *result);
    void processDevRemoveCompleteBroadcastOEM(DEV_BROADCAST_OEM *dev, long *result);
    void processDevRemoveCompleteBroadcastPort(DEV_BROADCAST_PORT *dev, long *result);
    void processDevRemoveCompleteBroadcastVolume(DEV_BROADCAST_VOLUME *dev, long *result);
    void processDevRemoveCompleteBroadcastHDR(DEV_BROADCAST_HDR *dev, long *result);
#endif
signals:
    void newUndefinedDevice();
    void newOEMDevice(int ID);
    void newPortDevice(const QString &name);
    void newVolumeDevice(const QString &disk, int flags);
    void removedUndefinedDevice();
    void removedOEMDevice(int ID);
    void removedPortDevice(const QString &name);
    void removedVolumeDevice(const QString &disk, int flags);
};

#endif // MyApp_H
