#include "MyApp.h"

#if defined(Q_OS_WIN32)

#ifndef IOCTL_STORAGE_QUERY_PROPERTY
#define IOCTL_STORAGE_QUERY_PROPERTY    CTL_CODE(IOCTL_STORAGE_BASE, 0x0500, METHOD_BUFFERED, FILE_ANY_ACCESS)
#endif

typedef enum _STORAGE_BUS_TYPE {
    BusTypeUnknown = 0x00,
    BusTypeScsi,
    BusTypeAtapi,
    BusTypeAta,
    BusType1394,
    BusTypeSsa,
    BusTypeFibre,
    BusTypeUsb,
    BusTypeRAID,
    BusTypeMaxReserved = 0x7F
} STORAGE_BUS_TYPE, *PSTORAGE_BUS_TYPE;

typedef struct _STORAGE_DEVICE_DESCRIPTOR {
    ULONG  Version;
    ULONG  Size;
    UCHAR  DeviceType;
    UCHAR  DeviceTypeModifier;
    BOOLEAN  RemovableMedia;
    BOOLEAN  CommandQueueing;
    ULONG  VendorIdOffset;
    ULONG  ProductIdOffset;
    ULONG  ProductRevisionOffset;
    ULONG  SerialNumberOffset;
    STORAGE_BUS_TYPE  BusType;
    ULONG  RawPropertiesLength;
    UCHAR  RawDeviceProperties[1];
  } STORAGE_DEVICE_DESCRIPTOR, *PSTORAGE_DEVICE_DESCRIPTOR;

typedef enum _STORAGE_QUERY_TYPE {
  PropertyStandardQuery = 0,
  PropertyExistsQuery,
  PropertyMaskQuery,
  PropertyQueryMaxDefined

} STORAGE_QUERY_TYPE, *PSTORAGE_QUERY_TYPE;

typedef enum _STORAGE_PROPERTY_ID {
  StorageDeviceProperty = 0,
  StorageAdapterProperty,
  StorageDeviceIdProperty

} STORAGE_PROPERTY_ID, *PSTORAGE_PROPERTY_ID;

typedef struct _STORAGE_PROPERTY_QUERY {
  STORAGE_PROPERTY_ID  PropertyId;
  STORAGE_QUERY_TYPE  QueryType;
  UCHAR  AdditionalParameters[1];

} STORAGE_PROPERTY_QUERY, *PSTORAGE_PROPERTY_QUERY;

BOOL GetDisksProperty(HANDLE hDevice, PSTORAGE_DEVICE_DESCRIPTOR pDevDesc)
{
    STORAGE_PROPERTY_QUERY  Query;
    DWORD   dwOutBytes;
    BOOL bResult;
    Query.PropertyId = StorageDeviceProperty;
    Query.QueryType = PropertyStandardQuery;
    bResult = DeviceIoControl(hDevice,
                              IOCTL_STORAGE_QUERY_PROPERTY,
                              &Query,
                              sizeof(STORAGE_PROPERTY_QUERY),
                              pDevDesc,
                              pDevDesc->Size,
                              &dwOutBytes,
                              (LPOVERLAPPED)NULL);
    return bResult;
}

char DriveLiterFromMask (ULONG unitmask)
{
    char i;
    for (i=0;i<26;++i) {
        if (unitmask & 0x1) {
            break;
        }
        unitmask >>= 1;
    }
    return (i + 'A');
}

#endif //Q_OS_WIN32

MyApp::MyApp(int &argc, char **argv)
    : QtSingleApplication(argc, argv)
{    
}

MyApp::~MyApp()
{

}

#if defined (Q_OS_WIN32)
bool MyApp::winEventFilter(MSG *msg, long *result)
{
    switch (msg->message) {
    case WM_DEVICECHANGE: {
            switch (msg->wParam) {
            case DBT_CONFIGCHANGECANCELED: processDbtConfigChangeCancelled(msg, result); break;
            case DBT_CONFIGCHANGED: processDbtConfigChanged(msg, result); break;
            case DBT_DEVICEARRIVAL: processDbtDeviceArrival(msg, result); break;
            case DBT_DEVICEQUERYREMOVE: processDbtDeviceQueryRemove(msg, result); break;
            case DBT_DEVICEQUERYREMOVEFAILED: processDbtDeviceQueryRemoveFailed(msg, result); break;
            case DBT_DEVICEREMOVECOMPLETE: processDbtDeviceRemoveComplete(msg, result); break;
            case DBT_DEVICEREMOVEPENDING: processDbtDeviceRemovePending(msg, result); break;
            case DBT_DEVICETYPESPECIFIC: processDbtDeviceTypeSpecific(msg, result); break;
            case DBT_DEVNODES_CHANGED: processDbtDevNodesChanged(msg, result); break;
            case DBT_QUERYCHANGECONFIG: processDbtQueryChangeConfig(msg, result); break;
            case DBT_USERDEFINED: processDbtUserdefined(msg, result); break;
            default: break;
            }
        }break;
    default :   break;
    }
    return QApplication::winEventFilter(msg, result);
}

void MyApp::processDbtConfigChangeCancelled(MSG *msg, long *result)
{

}

void MyApp::processDbtConfigChanged(MSG *msg, long *result)
{

}

void MyApp::processDbtDeviceArrival(MSG *msg, long *result)
{
    DEV_BROADCAST_HDR *dev = reinterpret_cast<DEV_BROADCAST_HDR*>(msg->lParam);
    switch (dev->dbch_devicetype) {
    case DBT_DEVTYP_OEM: processDevArrivalBroadcastOEM(reinterpret_cast<DEV_BROADCAST_OEM*>(dev), result); break;
    case DBT_DEVTYP_PORT: processDevArrivalBroadcastPort(reinterpret_cast<DEV_BROADCAST_PORT*>(dev), result); break;
    case DBT_DEVTYP_VOLUME: processDevArrivalBroadcastVolume(reinterpret_cast<DEV_BROADCAST_VOLUME*>(dev), result); break;
    default: processDevArrivalBroadcastHDR(dev, result); break;
    }
}

void MyApp::processDevArrivalBroadcastHDR(DEV_BROADCAST_HDR *dev, long *result)
{    
    Q_UNUSED(dev);
    Q_UNUSED(result);
    emit newUndefinedDevice();
}

void MyApp::processDevArrivalBroadcastOEM(DEV_BROADCAST_OEM *dev, long *result)
{   
   Q_UNUSED(result);
   emit newOEMDevice(dev->dbco_identifier);
}

void MyApp::processDevArrivalBroadcastPort(DEV_BROADCAST_PORT *dev, long *result)
{    
    Q_UNUSED(result);
    emit newPortDevice(QString::fromStdWString(dev->dbcp_name));
}

void MyApp::processDevArrivalBroadcastVolume(DEV_BROADCAST_VOLUME *dev, long *result)
{        
    Q_UNUSED(result);
    emit newVolumeDevice(QString(DriveLiterFromMask(dev->dbcv_unitmask)),dev->dbcv_flags);
}

void MyApp::processDbtDeviceQueryRemove(MSG *msg, long *result)
{

}

void MyApp::processDbtDeviceQueryRemoveFailed(MSG *msg, long *result)
{

}

void MyApp::processDbtDeviceRemoveComplete(MSG *msg, long *result)
{
    DEV_BROADCAST_HDR *dev = reinterpret_cast<DEV_BROADCAST_HDR*>(msg->lParam);
    switch (dev->dbch_devicetype) {
    case DBT_DEVTYP_OEM: processDevRemoveCompleteBroadcastOEM(reinterpret_cast<DEV_BROADCAST_OEM*>(dev), result); break;
    case DBT_DEVTYP_PORT: processDevRemoveCompleteBroadcastPort(reinterpret_cast<DEV_BROADCAST_PORT*>(dev), result); break;
    case DBT_DEVTYP_VOLUME: processDevRemoveCompleteBroadcastVolume(reinterpret_cast<DEV_BROADCAST_VOLUME*>(dev), result); break;
    default: processDevRemoveCompleteBroadcastHDR(dev, result); break;
    }
}

void MyApp::processDevRemoveCompleteBroadcastHDR(DEV_BROADCAST_HDR *dev, long *result)
{
    Q_UNUSED(dev);
    Q_UNUSED(result);
    emit removedUndefinedDevice();
}

void MyApp::processDevRemoveCompleteBroadcastOEM(DEV_BROADCAST_OEM *dev, long *result)
{
    Q_UNUSED(result);
    emit removedOEMDevice(dev->dbco_identifier);
}

void MyApp::processDevRemoveCompleteBroadcastPort(DEV_BROADCAST_PORT *dev, long *result)
{
    Q_UNUSED(result);
    emit removedPortDevice(QString::fromStdWString(dev->dbcp_name));
}

void MyApp::processDevRemoveCompleteBroadcastVolume(DEV_BROADCAST_VOLUME *dev, long *result)
{
    Q_UNUSED(result);
    emit removedVolumeDevice(QString(DriveLiterFromMask(dev->dbcv_unitmask)),dev->dbcv_flags);
}

void MyApp::processDbtDeviceRemovePending(MSG *msg, long *result)
{

}

void MyApp::processDbtDeviceTypeSpecific(MSG *msg, long *result)
{

}

void MyApp::processDbtDevNodesChanged(MSG *msg, long *result)
{

}

void MyApp::processDbtQueryChangeConfig(MSG *msg, long *result)
{

}

void MyApp::processDbtUserdefined(MSG *msg, long *result)
{

}
#endif

QRichFileInfo::QRichFileInfo(const QString &filePath)
    : QFileInfo(filePath)
{
    int bus_type = 0;
    int drv_type = 0;
#if defined(Q_OS_WIN32)
    char disk = filePath[0].toAscii();
    TCHAR drive[] = {disk,':','\\','\0'};
    DWORD drwType = GetDriveType(drive);
    TCHAR drv[] = {'\\','\\','?','\\',disk,':','\0'};
    HANDLE hDevice = CreateFile(drv, GENERIC_READ, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);
    if (hDevice != INVALID_HANDLE_VALUE) {
        PSTORAGE_DEVICE_DESCRIPTOR pDevDesc;
        DWORD devDescSz = sizeof(STORAGE_DEVICE_DESCRIPTOR) + 512 - 1;
        pDevDesc = reinterpret_cast<PSTORAGE_DEVICE_DESCRIPTOR>(qMalloc(devDescSz));
        pDevDesc->Size = devDescSz;
        if (GetDisksProperty(hDevice, pDevDesc)) {
            switch (pDevDesc->BusType) {
            case BusTypeScsi: bus_type = BUS_SCSI; break;
            case BusTypeAtapi: bus_type = BUS_ATAPI; break;
            case BusTypeAta: bus_type = BUS_ATA; break;
            case BusType1394: bus_type = BUS_1394; break;
            case BusTypeSsa: bus_type = BUS_SSA; break;
            case BusTypeFibre: bus_type = BUS_FIBRE; break;
            case BusTypeUsb: bus_type = BUS_USB; break;
            case BusTypeRAID: bus_type = BUS_RAID; break;
            case BusTypeUnknown:
            case BusTypeMaxReserved:
            default:
                bus_type = BUS_UNKNOWN;
                break;
            }
        }
    }
    switch (drwType) {
    case DRIVE_UNKNOWN: drv_type = DRV_UNKNOWN; break;
    case DRIVE_NO_ROOT_DIR: drv_type = DRV_NO_ROOT_DIR; break;
    case DRIVE_REMOVABLE: drv_type = DRV_REMOVABLE; break;
    case DRIVE_FIXED: drv_type = DRV_FIXED; break;
    case DRIVE_REMOTE: drv_type = DRV_REMOTE; break;
    case DRIVE_CDROM: drv_type = DRV_CDROM; break;
    case DRIVE_RAMDISK: drv_type = DRV_RAMDISK; break;
    default: drv_type = DRV_UNKNOWN; break;
    }
#endif
    driveInfo = drv_type | bus_type;
    onRemovable = ((driveInfo & BUS_USB) || (driveInfo & DRV_REMOVABLE) || (driveInfo & DRV_REMOTE));
}

bool QRichFileInfo::isOnRemovableDevice() const
{
    return onRemovable;
}

qint64 QRichFileInfo::getDriveInfo() const
{
    return driveInfo;
}


