######################################################################
# Temporary directory
######################################################################
isEmpty(TMPDIR){
	TMPDIR = ./tmp
	message(Auto set TMPDIR = $${TMPDIR})
}


######################################################################
# Hardcoded symbols: target name
######################################################################
#HARDCODED += target


######################################################################
# Hardcoded symbols: translations directory name
######################################################################
#HARDCODED += translationdir



######################################################################
isEmpty(DESTDIR){
	DESTDIR = ./
	contains(TEMPLATE, lib){
		DESTDIR = ./lib
	}else{
		DESTDIR = ./build
	}
	message(Auto set DESTDIR = $${DESTDIR})
}

TMP_DIR = $$TMPDIR

CONFIG (debug, debug|release) {
	contains(TEMPLATE, lib){
		TARGET = $$qtLibraryTarget($$TARGET)
	}else{
		TARGET  	= $$join(TARGET,,,.d)
	}
	OBJECTS_DIR = $${TMP_DIR}/debug
	CONFIG 	   += console
}else{
	OBJECTS_DIR = $${TMP_DIR}/release
}

UI_DIR      = $${TMP_DIR}/uic
MOC_DIR     = $${TMP_DIR}/moc
RCC_DIR		= $${TMP_DIR}/rcc

contains(CONFIG, debug_and_release) {
	CONFIG 	   += build_all
}


contains(DEBUGCONFIG, true){
	message(CONFIG = $${CONFIG})
	message(DESTDIR=$${DESTDIR})
	message(TARGET=$${TARGET})
	message(TMPDIR=$${TMPDIR})
	message(TMP_DIR=$${TMP_DIR})
	message(OBJECTS_DIR=$${OBJECTS_DIR})
	message(INCLUDEPATH = $${INCLUDEPATH})
	message(QMAKE_LIBDIR = $${QMAKE_LIBDIR})
	message(LIBS = $${LIBS})	
	message(===================================)
}

contains(HARDCODED, TARGET) {
	TARGETTMP = '\\"$${TARGET}\\"'
	DEFINES  += TARGET=\"$${TARGETTMP}\"
}