#include <QtGui>
#include "mywidget.h"

MyTileWidget::MyTileWidget( QWidget *parent )
	: QFrame( parent )
{
   // palette.setColor(QPalette::Background,Qt::red);
   // setPalette(palette);
    signalMapper = new QSignalMapper(this);
    menu = new QMenu;

    QVector<QString> tilesType;
    tilesType.append(QString("Pin"));
    tilesType.append(QString("Sou"));
    tilesType.append(QString("Man"));

    foreach(QString type, tilesType){
        QAction* action = new QAction(type,menu);
        QObject::connect(action,SIGNAL(triggered()),signalMapper,SLOT(map()));
        signalMapper->setMapping(action,type);
        menu->addAction(action);
    }

    QObject::connect(signalMapper,SIGNAL(mapped(QString)),this,SIGNAL(clicked(QString)));
    QObject::connect(this,SIGNAL(clicked(QString)),this,SLOT(slotChangeColor(QString)));


    QMenu* submenuOne = new QMenu("Sub menu one",menu);
    QMenu* subsubmenuTwo = new QMenu("Sub sub menu",menu);
    QMenu* subsubmenuThree = new QMenu("Sub menu three",menu);

    subsubmenuThree->addAction(new QAction("subsubpt13",subsubmenuThree));
    subsubmenuThree->addAction(new QAction("subsubpt23",subsubmenuThree));
    subsubmenuThree->addAction(new QAction("subsubpt33",subsubmenuThree));

    subsubmenuTwo->addAction(new QAction("subsubpt1",subsubmenuTwo));
    subsubmenuTwo->addAction(new QAction("subsubpt2",subsubmenuTwo));
    subsubmenuTwo->addMenu(subsubmenuThree);

    submenuOne->addAction(new QAction("subpt1",submenuOne));
    submenuOne->addAction(new QAction("subpt2",submenuOne));
    submenuOne->addMenu(subsubmenuTwo);

    menu->addMenu(submenuOne);

    setFixedSize(QSize(60,90));
}

void MyTileWidget::paintEvent(QPaintEvent* ev)
{
	QWidget::paintEvent( ev );

    QPainter painter(this);

    painter.setFont(QFont("Arial", 20));
    painter.drawText(rect().x()+height()/6,rect().y()+width(),"Tile");

    painter.drawRect(QRect(0,0,width()-2,height()-2));
}

void MyTileWidget::mousePressEvent (QMouseEvent * event)
{
        if(event->buttons()==Qt::RightButton){
           menu->move( event->globalPos() );
           menu->show();
       }
}

void MyTileWidget::slotChangeColor(QString type)
{
    if(type=="Pin"){
        setStyleSheet("background-color: green");
        //qDebug()<<"Olol is PIN!";
        //qDebug()<<sender()->metaObject()->className();
    }
    else if(type=="Sou")
    {
        this->setStyleSheet("background-color: red");
        //qDebug()<<"Haha its SOU!";
    }
    else if(type=="Man")
        qDebug()<<"TT its MAN!";
        //pal.setColor(QPalette::Background,Qt::red);
    else
        qDebug()<<"Its not here!";
}
