#ifndef XMLSTREAMREADERHELPER_H
#define XMLSTREAMREADERHELPER_H

#include <QtCore/QXmlStreamReader>
#include <QtCore/QEventLoop>
#include <QtCore/QSharedPointer>
#include <QtCore/QMap>

class AbstractTagImplementator;

class AbstractTagImplementator
{
public:
    AbstractTagImplementator(const QString &name = QString(), AbstractTagImplementator *parent = 0);
    bool parse();
    void setProcessor(const QString &tagName = QString(), AbstractTagImplementator *processor = 0);
    AbstractTagImplementator * processor(const QString &tagName = QString()) const;
    static QEventLoop *eventLoop();
    static void setXmlReader(QXmlStreamReader *reader) {m_xml = reader;}
    inline QXmlStreamReader * xml() const {return m_xml;}
    inline AbstractTagImplementator * parent() const {return m_parent;}
    void setParent(AbstractTagImplementator *parent);
    inline const QString & name() const {return m_tagName;}
    inline void setName(const QString &name) {m_tagName = name;}
    bool processTag();
    virtual ~AbstractTagImplementator();

private:
    void cycle();
    virtual bool beforeEvent();
    virtual void afterEvent();
    virtual bool event();
    virtual bool isCritical();
    virtual bool appendMoreData();

    static QXmlStreamReader *m_xml;
public:
    QXmlStreamReader::TokenType token;

protected:
    QMap<QString, AbstractTagImplementator *> processors;
    QString m_tagName;
    AbstractTagImplementator *m_parent;
};

class SkipSubTree : public AbstractTagImplementator
{
public:
    bool event();
    bool beforeEvent();
private:
    QString tagName;
};

class SkipTags : public AbstractTagImplementator
{
public:
    bool skip(quint32 count);
private:
    bool event();

    quint32 m_count;
};

class MoveToNextTag : public AbstractTagImplementator
{
public:
    bool event();
};

class MoveToTag : public AbstractTagImplementator
{
public:
    bool moveTo(const QString &tagName = QString());
private:
    bool event();

    QString m_tagName;
};

class AbstractTagProcessor : public AbstractTagImplementator
{
public:
    AbstractTagProcessor(const QString &name = QString(), AbstractTagImplementator *parent = 0);
    bool skipSubTree();
    bool moveToNextTag();
    bool moveToTag(const QString &tagName = QString());
    bool skipTags(quint32 count);

protected:
    SkipSubTree m_skipSubTree;
    MoveToNextTag m_moveToNextTag;
    MoveToTag m_moveToTag;
    SkipTags m_skipTags;
};
#endif // XMLSTREAMREADERHELPER_H
