#include "mdimainwindow.h"
//
MdiMainWindow::MdiMainWindow( QWidget * parent, Qt::WFlags f) 
	: QMainWindow(parent, f)
{
	workspace = new QWorkspace;
	workspace->setScrollBarsEnabled(true);
	setCentralWidget(workspace);
		
	workWithDatabase = new WorkWithDatabase("minienterprise.htm");	
	
	QTextEdit *text = new QTextEdit;
	text->setWindowTitle("текст");
	text->setText(workWithDatabase->GetUsersNameList().join(", "));
	text->append(QString::number(workWithDatabase->GetStatusByName("Администратор")));
	workspace->addWindow(text);
	text->show(); 
	
	QLineEdit *line = new QLineEdit;
	line->setText(QString::number(workWithDatabase->GetCountUsers()));
	workspace->addWindow(line);
	line->show();
	
	QDockWidget *dock = new QDockWidget;
	dock->setFeatures(QDockWidget::AllDockWidgetFeatures);
	workspace->addWindow(dock);
	dock->show();
	
	menuBar()->addMenu(CreateMenuFile());
	menuBar()->addMenu(CreateMenuAbout());
}
//

QMenu *MdiMainWindow::CreateMenuFile()
{
	QMenu *menu = new QMenu("Файл");	
	
	return menu;
}

QMenu *MdiMainWindow::CreateMenuAbout()
{
	QMenu *menu = new QMenu("?");	
	
	return menu;
}

