#include "workwithdatabase.h"
//
WorkWithDatabase::WorkWithDatabase(QString dbName) 
{
	SetDatabaseName(dbName);
	ConnectToDatabase();
	query = new QSqlQuery;
	CreateTables();
	//AddUserInDatabase("0", "Администратор", "админ", 100);
	//AddUserInDatabase("1", "Продавец №1", "111", 10);
	//AddUserInDatabase("2", "Продавец №2", "222", 10);
	//GetTableUsers();
}

void WorkWithDatabase::SetDatabaseName(QString dbName)
{
	databaseName = dbName;
}

QString WorkWithDatabase::GetDatabaseName()
{
	return databaseName;
}
	
bool WorkWithDatabase::ConnectToDatabase()
{
	QSqlDatabase db = QSqlDatabase::addDatabase("QSQLITE");
	db.setDatabaseName(GetDatabaseName());
	
	if (!db.open())
	{
		qDebug()<<"Ошибка при открытии базы данных : "<<db.lastError();
		return false;
	}
	return true;
}

bool WorkWithDatabase::CreateTables()
{	QString str="CREATE TABLE users(id VARCHAR(50) PRIMARY KEY NOT NULL,"
									"name VARCHAR(50) NOT NULL,"
									"password VARCHAR(50) NOT NULL,"
									"status SMALLINT NOT NULL);";
	
		
	if (!query->exec(str))
	{
	// если возникнит ошибка, то проигнорируем
	//	qDebug()<<"Ошибка при создании таблицы users. Возможно таблица уже создана";
	}
	
	return 0;	
}

bool WorkWithDatabase::AddUserInDatabase(QString id, QString name, QString password, signed int status)
{
	QString strF="INSERT INTO users (id, name, password, status) VALUES('%1', '%2', '%3', %4);";

	// шифруем пароль с помощью алгоритма md5
	QCryptographicHash hash(QCryptographicHash::Md5);
	hash.addData(password.toUtf8());
	password=hash.result().toHex().data();

	QString str=strF.arg(id).arg(name).arg(password).arg(status);
	
	if (!query->exec(str))
	{
		qDebug()<<"Error to add to database";
		return false;
	}
	return true;
}

void WorkWithDatabase::GetTableUsers()
{
	QString str="SELECT * FROM users;";
	//QSqlRecord rec=query->record();
	QString id,name,password;
	int status;

	if (!query->exec(str))
	{
		qDebug()<<"Error to read table users";
		return;
	}

	while (query->next())
	{
		id       = query->value(0).toString();
		name     = query->value(1).toString();
		password = query->value(2).toString();
		status   = query->value(3).toInt();
		
		qDebug()<<id<<"  "<<name<<"  "<<password<<"  "<<status;	
	}
}

QStringList WorkWithDatabase::GetUsersNameList()
{
	QStringList list;
	QString name;
	QString str = "SELECT name FROM users;";
	
	if (!query->exec(str))
	{
		qDebug()<<"Error in GetUsersNameList";
		return QStringList("");
	}
	
	while (query->next())
	{
		name   = query->value(0).toString();
		list<<name;
	}
	return list;
}

int WorkWithDatabase::GetCountUsers()
{
	int count;
	QString str = "SELECT count(*) FROM users;";
	
	if (!query->exec(str))
	{
		qDebug()<<"Error in GetCountUsers";
		return 0;
	}
	
	query->next();
	count = query->value(0).toInt(); 	
	return count;
}

int WorkWithDatabase::GetStatusByName(QString name)
{
	int status;
	QString str = "SELECT status FROM users WHERE name='"+name+"';";	
	
	if (!query->exec(str))
	{
		//qDebug()<<str;
		qDebug()<<"Error in GetStatusByName";
		return 0;
	}
	
	if (!query->next())
	{
		return 0;
	}
	status = query->value(0).toInt();
	return status;	
}
