#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QClipboard>

#include <ui_mainwindow.h>
#include "graphsv.h"

/*! \brief небольшой пример как использовать библиотеку
  *
  * Пока не реализовано автоматическое масштабирование. Для этого
  * надо наследоваться от QGraphicsView и переопределять его
  * реакиции на изменение размера
  */

class MainWindow : public QMainWindow, private Ui::MainWindow
{
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();
private:
    GraphSV* graph;
private slots:
    void changeAxesCount();
    void resizeScene();
    void setTicksCount();
    void addSeries();
    void copyToClipboard();
};

#endif // MAINWINDOW_H
