#include "mainwindow.h"

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    setupUi(this);
    graph = new GraphSV(this);
    graph->setAxesCount(3);
    graphicsView->setScene(graph);
    connect(pushButton, SIGNAL(clicked()), this, SLOT(changeAxesCount()));
    connect(pushButton_2, SIGNAL(clicked()), this, SLOT(resizeScene()));
    connect(pushButton_3, SIGNAL(clicked()), this, SLOT(setTicksCount()));
    connect(pushButton_4, SIGNAL(clicked()), this, SLOT(addSeries()));
    connect(pushButton_5, SIGNAL(clicked()), this, SLOT(copyToClipboard()));
}

MainWindow::~MainWindow()
{
}

void MainWindow::changeAxesCount()
{
    graph->setAxesCount(spinBox->value());
    graph->redraw();
    resizeScene();
}

void MainWindow::resizeScene()
{
    graphicsView->fitInView(graph->border(), Qt::KeepAspectRatio);
}

void MainWindow::setTicksCount()
{
    graph->setTicks(5);
}

void MainWindow::addSeries()
{
    QList<float> values;
    values << 70 << 30 << 50 << 100 << 40;
    graph->addSeries("series1", &values);
    graph->series()->setColor("series1", QColor(Qt::red));
    QList<float> values2;
    values2 << 10 << 30 << 0 << 80 << 20 << 70;
    graph->addSeries("series2", &values2);
    graph->series()->setColor("series2", QColor(Qt::blue));
    graph->redraw();
}

void MainWindow::copyToClipboard()
{
    QRectF bounds = graph->border()->boundingRect();
    QPixmap pixmap(bounds.width(), bounds.height());
    pixmap.fill(QColor(Qt::white));
    QPainter painter(&pixmap);
    painter.setRenderHint(QPainter::Antialiasing);
    graph->render(&painter, pixmap.rect(), bounds);
    painter.end();
    QClipboard *clipboard = qApp->clipboard();
    clipboard->setPixmap(pixmap);
}
