#ifndef SERIESSV_H
#define SERIESSV_H

#include <QGraphicsPathItem>

#include "graphsv_global.h"

class GraphSV;
class AxeSV;

class GRAPHSVSHARED_EXPORT SeriesSV
{
public:
    /*! \brief Конструктор */
    SeriesSV(GraphSV *parent);
    /*! \brief Отрисовка графиков */
    void drawSeries(const QList<AxeSV*>& axes, QString name = QString());
    /*! \brief Добавление серии */
    void addSeries(QString name, QList<float>* points = 0);
    /*! \brief Установка цвета серии */
    void setColor(QString name, QColor color);
private:
    /*! \brief Список серий */
    QHash<QString, QGraphicsPathItem*> seriesList;
    /*! \brief Список точек серий */
    QHash<QString, QList<float> > data;
    /*! \brief Список имен серий */
    QList<QString> seriesNames;
    /*! \brief Указатель на сцену
      *
      * Этот указатель понадобится при добавлении и удалении серии
      */
    GraphSV* scene;
};

#endif // SERIESSV_H
