#include "seriessv.h"
#include "graphsv.h"
#include "axesv.h"

/*! \param parent Указатель на родительский GraphSV.
  * Можно было бы использовать обычный QObject, но я не
  * люблю приведений типов :)
  */
SeriesSV::SeriesSV(GraphSV *parent)
{
    scene = parent;
}

/*! \param axes Список осей графика
  * \param name Имя конкретной серии для перерисовки. Пока оно
  * не используется, и я не знаю, нужно ли это вообще?
  */
void SeriesSV::drawSeries(const QList<AxeSV*>& axes, QString name)
{
    //Отрисовываем только указанную ось
    if (!name.isEmpty()) {
        qDebug("Fixme: SeriesSV::drawSeries() not fully implemented");
        return;
    }

    for (int i = 0; i < seriesNames.count(); i++) {
        QList<float> values = data.value(seriesNames.at(i));
        QGraphicsPathItem* item = seriesList.value(seriesNames.at(i));
        //Вычисляем столько нам надо найти координат
        int count = 0;
        //Если число значений меньше, добавляем один ноль в конец
        if (values.count() < axes.count()) {
            values.append(0);
            count = values.count();
        //Если больше, то удаляем лишнее
        } else
            count = axes.count();

        QPainterPath path;
        QPointF startPoint = axes.at(0)->pointAt(values.at(0));
        path.moveTo(startPoint);
        for (int j = 1; j < count; j++) {
            path.lineTo(axes.at(j)->pointAt(values.at(j)));
        }
        path.lineTo(startPoint);
        item->setPath(path);
    }
}

/*! \param name Имя добавляемой серии
  * \param points Список точек серии. Необязательный параметр, но
  * пока нет функции для изменения уже существующей серии
  */
void SeriesSV::addSeries(QString name, QList<float>* points)
{
    //Что-то делать если такая серия уже есть
    if (data.contains(name)) {
        return;
    }

    QList<float> list;
    if (points)
        list.append(*points);

    data.insert(name, list);
    seriesNames.append(name);
    QPen pen;
    pen.setWidth(3);
    QGraphicsPathItem* item = new QGraphicsPathItem();
    item->setPen(pen);
    seriesList.insert(name, item);
    scene->addItem(item);
}

/*! \param name Имя серии для которой надо изменить цвет
  * \param color Новый цвет серии
  */
void SeriesSV::setColor(QString name, QColor color)
{
    QGraphicsPathItem* item = seriesList.value(name);
    if (!item)
        return;
    QPen pen;
    pen = item->pen();
    pen.setColor(color);
    item->setPen(pen);
}
