#ifndef GRIDSV_H
#define GRIDSV_H

#include <QGraphicsItem>

class GraphSV;
class AxeSV;

/*! \brief Сетка графика */
class GridSV
{
public:
    /*! \brief Конструктор */
    GridSV();
    /*! \brief Установка видимости оси */
    void setVisible(bool mode = true) { visible = mode; }
    /*! \brief Получение флага видимости */
    bool isVisible() { return visible; }
    /*! \brief Установка числа линий сетки */
    void draw(GraphSV* scene, const QList<AxeSV*>& axes, int ticksCount);
private:
    /*! \brief Флаги видимости сетки */
    bool visible;
    /*! \brief Список сеток графика */
    QList<QGraphicsPathItem*> grids;
};

#endif // GRIDSV_H
