#include "gridsv.h"
#include "graphsv.h"
#include "axesv.h"

GridSV::GridSV()
{
    visible = false;
}

/*!
  * \param scene Сцена для отрисовки графика
  * \param axes Список указателей на оси графика
  * \param ticksCount Число линий сетки
  */
void GridSV::draw(GraphSV* scene, const QList<AxeSV*>& axes, int ticksCount)
{
    //Удаляем старую сетку
    while (!grids.isEmpty()) {
        QGraphicsPathItem* grid = grids.takeLast();
        scene->removeItem(grid);
        delete grid;
    } //while

    //Небольшая подстраховка
    if (axes.isEmpty())
        return;

    //Добавляем новые
    //Настройка пера
    QVector<qreal> pattern;
    pattern << 3 << 5 << 3 << 5;
    QPen pen;
    pen.setWidthF(0.5);
    pen.setColor(Qt::lightGray);
    pen.setDashPattern(pattern);
    pen.setStyle(Qt::CustomDashLine);

    float step = (scene->getMax() - scene->getMin())/ticksCount;

    for (int i = 0; i < ticksCount; i++) {
        QGraphicsPathItem* grid = new QGraphicsPathItem();
        grid->setPen(pen);
        QPainterPath path;
        QPointF startPoint = axes.at(0)->pointAt(step*(i + 1));
        path.moveTo(startPoint);
        for (int j = 1; j < axes.count(); j++) {
            path.lineTo(axes.at(j)->pointAt(step*(i + 1)));
        }
        path.lineTo(startPoint);
        grids.append(grid);
        scene->addItem(grid);
        grid->setPath(path);
    }
}
