#ifndef GRAPHSV_H
#define GRAPHSV_H

#include <QGraphicsScene>
#include <QGraphicsEllipseItem>

#include "graphsv_global.h"

//class AxeSV;
//class GridSV;
//class SeriesSV;

#include <axesv.h>
#include <gridsv.h>
#include <seriessv.h>

/*! \brief График в виде звезды */
class GRAPHSVSHARED_EXPORT GraphSV : public QGraphicsScene {
public:
    /*! \brief Конструктор */
    GraphSV(QObject* parent = 0);
    /*! \brief Установка нового числа осей */
    void setAxesCount(int newCount);
    /*! \brief Просмотр числа осей */
    int axesCount() { return axes.count(); }
    /*! \brief Получение границ графика */
    QGraphicsItem* border() { return myBorder; }
    /*! \brief число меток на осях*/
    int ticks() { return myTicks; }
    /*! \brief Установка числа меток */
    void setTicks(int number);
    /*! \brief Установка максимального значения */
    void setMax(float newMax);
    /*! \brief Установка минимального значения */
    void setMin(float newMin);
    /*! \brief Получение максимального значения */
    float getMax() { return max; }
    /*! \brief Получение минимального значения */
    float getMin() { return min; }
    /*! \brief Добавление серии */
    void addSeries(QString name, QList<float>* points = 0);
    /*! \brief Удаление указанной серии */
    void deleteSeries(QString name);
    /*! \brief Доступ к серии */
    SeriesSV*& series() { return mySeries; }
    /*! \brief Принудительная перерисовка графика */
    void redraw();
    /*! \brief Деструктор */
    ~GraphSV();
private:
    /*! \brief Список осей графика */
    QList<AxeSV*> axes;
    /*! \brief Граница графика
      *
      * В качестве границы удобно использовать QGraphicsPathItem
      * по двум причинам:
      * - его функция boundingRect() возвращает прямоугольную область графика
      * - для центрирования и масштабирования графика в виде удобно
      *   использовать fitInView(), передавая этот объект в качестве
      *   аргумента
      * В конструкторе он делается полностью прозрачным
      */
    QGraphicsPathItem* myBorder;
    /*! \brief Сетка */
    GridSV* grid;
    /*! \brief Серии данных */
    SeriesSV* mySeries;
    /*! \brief Число меток */
    int myTicks;
    /*! \brief Максимальное значение по оси */
    float max;
    /*! \brief Минимальное значение по оси */
    float min;
};

#endif // GRAPHSV_H
