#include "graphsv.h"
#include "axesv.h"
#include "gridsv.h"

/*! \param parent Указатель на объект родителя */
GraphSV::GraphSV(QObject* parent) : QGraphicsScene(parent)
{
    //Устанавливаем размер сцены
    setSceneRect(QRectF(-125, -125, 250, 250));

    //Граница графика
    myBorder = new QGraphicsPathItem;
    myBorder->setOpacity(0);
    addItem(myBorder);

    //Создаем объект сетки
    grid = new GridSV;
    grid->setVisible();

    //Создаем объект серий
    mySeries = new SeriesSV(this);

    //Инициализируем переменные
    max = 100;
    min = 0;
    myTicks = 0;
}

GraphSV::~GraphSV()
{
    delete grid;
    delete mySeries;
}

/*!
  * \param newCount Новое число осей
  */
void GraphSV::setAxesCount(int newCount)
{
    AxeSV* item;
    //Если число осей стало меньше, выкидываем лишние
    if (newCount < axes.count()) {
        while (newCount != axes.count()) {
            item = axes.takeLast();
            removeItem(item);
            delete item;
        } //while
    //Иначе добавляем новые
    } else {
        while (newCount != axes.count()) {
            item = new AxeSV;
            axes.append(item);
            addItem(item);
        }
    }

    //Установка углов всем осям и корректировка границ графика
    QPainterPath path;
    for (int i = 0; i < axesCount(); i++ ) {
        AxeSV* axis = axes.at(i);
        axis->setAngle(360.0/axes.count()*i);
        path.lineTo(axis->pointAt(125));
    }
    myBorder->setPath(path);
}

/*! \param number новое число меток */
void GraphSV::setTicks(int number)
{
    if (number < 0)
        return;

    myTicks = number;

    for (int i = 0; i < axes.count(); i++)
        axes.at(i)->setTicksCount(myTicks);

    redraw();
}

/*! \param newMax Новое максимальное значение
  * Пока это никак не используется...
  */
void GraphSV::setMax(float newMax)
{
    //Не допускаем что бы максимальное значение было меньше минимального
    if (newMax < min)
        return;
    max = newMax;

    for (int i = 0; i < axes.count(); i++)
        axes.at(i)->setMax(newMax);
}

/*! \param newMin Новое максимальное значение
  * Пока это никак не используется...
  */
void GraphSV::setMin(float newMin)
{
    //Не допускаем что бы минимальное значение было больше максимального
    if (newMin > max)
        return;
    min = newMin;

    for (int i = 0; i < axes.count(); i++)
        axes.at(i)->setMin(newMin);
}

/*!
  * В принципе после добавления функции series() данная функция не нужна
  * \param name Имя серии
  * \param points Список значений
  */
void GraphSV::addSeries(QString name, QList<float>* points)
{
    mySeries->addSeries(name, points);
}

/*!
  * Пока еще не доделана
  * \param name Имя серии для удаления
  */
void GraphSV::deleteSeries(QString name)
{
    qDebug("Fixme: GraphSV::deleteSeries() not fully implemented");
}

void GraphSV::redraw()
{
    grid->draw(this, axes, myTicks);
    mySeries->drawSeries(axes);
}
