#ifndef AXESV_H
#define AXESV_H

#include <QGraphicsItem>
#include <QPainter>

/*! \brief Ось графика в виде звезды */
class AxeSV : public QGraphicsItem
{
public:
    /*! \brief конструктор */
    AxeSV(QGraphicsItem *parent=0);
    /*! \brief Получение текущего угла оси */
    float getAngle() { return angle; }
    /*! \brief Установка угла оси */
    void setAngle(float newAngle);
    /*! \brief Установка максимального значения */
    void setMax(float newMax);
    /*! \brief Установка минимального значения */
    void setMin(float newMin);
    /*! \brief Получение максимального значения */
    float getMax() { return max; }
    /*! \brief Получение минимального значения */
    float getMin() { return min; }
    /*! \brief Получение числа меток оси */
    float getTicksCount() { return ticksCount; }
    /*! \brief Установка числа меток оси */
    void setTicksCount(int newTicksCount);
    /*! \brief Область рисования оси */
    QRectF boundingRect() const;
    /*! \brief Процедура отрисовки оси */
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget);
    /*! \brief Точка метки */
    QPointF ticksPoint(int number) { return ticksPoints.at(number); }
    /*! \brief Определение координаты произвольной точки на графике */
    QPointF pointAt(float value);
private:
    /*! \brief Угол оси */
    float angle;
    /*! \brief Число меток оси */
    int ticksCount;
    /*! \brief Максимальное значение оси */
    float max;
    /*! \brief Минимальное значение по оси */
    float min;
    /*! \brief Вектор точек меток */
    QList<QPointF> ticksPoints;
};

#endif // AXESV_H
