#include "axesv.h"

/*! \param parent Указатель на объект родителя */
AxeSV::AxeSV(QGraphicsItem *parent) : QGraphicsItem(parent)
{
    //Инициализация переменных
    angle = 90;
    ticksCount = 5;
    setTicksCount(6);
    max = 100;
    min = 0;

    //Парочка флагов. Просто что бы проверить вкусности Graphic View Framework
    //Теперь оси можно таскать мышкой
    setFlag(QGraphicsItem::ItemIsSelectable);
    setFlag(QGraphicsItem::ItemIsMovable);
}

/*! \param newAngle Новый угол наклона оси */
void AxeSV::setAngle(float newAngle)
{
    //Обеспечиваем что бы угол был в пределах [0;360]
    float delta;
    if (newAngle > 360)
        delta = -360;
    else
        delta = 360;
    while (newAngle < 0 || newAngle > 360)
        newAngle += delta;
    //Поворачиваем ось
    rotate(newAngle - angle);
    angle = newAngle;
}

/*! \param newMax Новое максимальное значение
  * Пока это никак не используется...
  */
void AxeSV::setMax(float newMax)
{
    //Не допускаем что бы максимальное значение было меньше минимального
    if (newMax < min)
        return;
    max = newMax;
}

/*! \param newMin Новое максимальное значение
  * Пока это никак не используется...
  */
void AxeSV::setMin(float newMin)
{
    //Не допускаем что бы минимальное значение было больше максимального
    if (newMin > max)
        return;
    min = newMin;
}

/*! \param newTicksCount Новое число меток на оси
  * Раньше массив ticksPoints использовался для построения сетки
  * Теперь сетка отрисовывается с помощью pointAt()
  * В принципе эту функцию можно удалять
  */
void AxeSV::setTicksCount(int newTicksCount)
{
    ticksPoints.clear();
    if (newTicksCount < 0)
        return;
    ticksCount = newTicksCount;

    float step = 100.0/ticksCount;
    for (int i = 1; i <= ticksCount; i++) {
        ticksPoints.append(QPointF(step*i, 0));
    }
}

/*! \return Прямоугольник, ограничивающий ось. Используется сценой
  * для отрисовки
  */
QRectF AxeSV::boundingRect() const
{
    //TODO: Возвращать более точные координаты
    return QRectF(0, -5, 120, 5);
}

/*! \paragraph Параметры функции можно посмотреть в справке
  * по QGraphicsItem */
void AxeSV::paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
                  QWidget *widget)
{
    //Устанавливаем перо
    QPen pen;
    pen.setWidthF(1);
    painter->setPen(pen);

    //Рисуем ось и стрелку
    painter->drawLine(0, 0, 120, 0);
    painter->drawLine(120, 0, 113, 3);
    painter->drawLine(120, 0, 113, -3);

    //Делаем метки на оси
    float step = 100.0/ticksCount;
    for (int i = 1; i <= ticksCount; i++) {
        painter->drawLine(QPointF(step*i, 1.5), QPointF(step*i, -1.5));
    }
}

/*!
  * Используется для отрисовки сетки и самих графиков (series)
  * \param value Значение оси для которого надо найти координаты
  * \return Координаты искомой точки.
  */
QPointF AxeSV::pointAt(float value)
{
    // 100 = max - min
    //  x  = value - min
    // тогда x = 100*(value - min)/(max - min)
    return QPointF(mapToScene(100.0*(value - min)/(max - min), 0));
}
