#include <QtGui/QMouseEvent>
#include <QtGui/QBitmap>
#include <QtGui/QPainter>
#include <QtCore/QTimer>
#include <QDesktopWidget>
#include <QtDebug>
#include "gifwindow.h"

GifMaskWidget::GifMaskWidget(QWidget *parent)
    : QLabel(parent, Qt::FramelessWindowHint | Qt::Window), mirror(false)
{
    movie.setFileName("../persian.gif");

    if(movie.isValid()) {
       movie.jumpToFrame(0);
       pix = movie.currentPixmap();
       setPixmap(pix);
       setMask(pix.mask());
    } else {
        close();
    }

    QDesktopWidget desktop;
    desktopRect = desktop.availableGeometry(desktop.primaryScreen());
    move(desktopRect.bottomLeft() + QPoint(0, -50));
    
    QTimer *timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(nextGifImage()));
    timer->start(movie.nextFrameDelay());
}

void GifMaskWidget::mousePressEvent(QMouseEvent* event)
{
    if(event->button() == Qt::RightButton) {
        close();
    } else {
        position = event->pos();
    }
}

void GifMaskWidget::mouseMoveEvent(QMouseEvent* event)
{
    move(event->globalPos() - position);
}

void GifMaskWidget::nextGifImage()
{
    if(movie.isValid()) {
        movie.jumpToNextFrame();
        image = movie.currentImage();
        if(mirror) image = image.mirrored(true,false);
        pix = QPixmap::fromImage(image);
        setPixmap(pix);
        setMask(pix.mask());
    } else {
        movie.jumpToFrame(0);
    }

    if(!mirror) {
        move(pos() + QPoint(5,0));
        if(desktopRect.width() - 116 < (pos().x()))
            mirror = true;
    } else {
        move(pos() - QPoint(5,0));
        if(!pos().x())
            mirror = false;
    }
}



