#include <QtGui>
#include "form.h"

static void childsRecursive(QObject *object, QWidget *watcher, bool install)
{
    if (object->isWidgetType()) {
        if (install) object->installEventFilter(watcher);
        else object->removeEventFilter(watcher);
        QWidget *widget = qobject_cast<QWidget*>(object);
        widget->setAutoFillBackground(true);
    }
    QObjectList children = object->children();
    foreach(QObject *child, children) {
        childsRecursive(child, watcher, install);
    }
}

form::form(QWidget *parent) : QMainWindow(parent), count(1)
{
    resize(300, 100);
    centralwidget = new QWidget(this);
    setCentralWidget(centralwidget);

    QTextEdit *textedit = new QTextEdit(centralwidget);
    QRadioButton *rb = new QRadioButton("radioButton", centralwidget);
    QCheckBox *cb = new QCheckBox("checkBox", centralwidget);
    QComboBox *cmb = new QComboBox(centralwidget);
    QPushButton *btn = new QPushButton("text", textedit);

    QVBoxLayout *vl = new QVBoxLayout(centralwidget);
    vl->addWidget(textedit);
    vl->addWidget(btn);
    vl->addWidget(cb);
    vl->addWidget(cmb);
    vl->addWidget(rb);

    centralwidget->setLayout(vl);
    childsRecursive(centralwidget, this, true);

    imageR.setFileName("../cheltelik.gif");
    imageR.setScaledSize(QSize(126,112));

    QTimer *timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(myslot2()));
    timer->start(300);
}


bool form::eventFilter(QObject *obj, QEvent *event)
{
    if(event->type() == QEvent::Paint) {
        QWidget *widget = qobject_cast<QWidget*>(obj);
        widget->setAutoFillBackground(false);

        obj->removeEventFilter(this);
        QApplication::sendEvent(obj, event);
        obj->installEventFilter(this);
        widget->setAutoFillBackground(true);

        QPoint point = widget->pos();
        while(widget && (widget->parentWidget() != this)) {
            widget = widget->parentWidget();
            point += widget->pos();
        }

        QRect r = qobject_cast<QWidget*>(obj)->rect().translated(point);

        QPainter p(qobject_cast<QWidget*>(obj));
        p.setWindow(r);
        p.drawImage(85,-10, image);

        return true;
    }
    return false;
}

void form::myslot2()
{
    if(imageR.canRead()) {
        image = imageR.read();
    } else return;
    update();

    count++;
    if (count == 10) {
        count = 1;
        imageR.setFileName("../cheltelik.gif");
    }
}
