#include <QtGui/QWidget>

#ifndef GAMEFIELD_H_
#define GAMEFIELD_H_

class GameField : public QWidget  {
	Q_OBJECT

public:
	explicit GameField(QWidget *parent = 0);
	virtual ~GameField();

protected:
	void paintEvent(QPaintEvent *event);
	void keyPressEvent (QKeyEvent *event);

private:
        QTimer *timer;
        QTimer *createTimer;
        QPixmap pixmap;
	QPolygon soliter;
	QPolygon foot;
        QPolygon rectScen;
        QPolygon currentLavel;
        QPoint shiftPoint;

        int len;
        int startlen;
	enum Napr {Up, Down, Left, Right};
	Napr napr;
	Napr tempState;
	bool pause;
	int lavel;
	int live;
	int finishLen;

	void createLavel();
	void drawScen();
	void nextLavel();
	void coordSoliter();
	void drawElemScen(QPainter *painter, int X, int Y);
	void drawSoliter(QPainter *painter);
	void drawFoot(QPainter *painter);

private slots:
	void rebuild();
	void createFoot();
	void newGame();
	void pauseUpdate();
	void dead();

signals:
	void lenSoliter(int num);
	void setLive(int num);
	void setLavel(int num);
	void setTarget(int num);
};

#endif /* GAMEFIELD_H_ */
