#include <QApplication>
#include <QMainWindow>
#include <QWidget>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QGridLayout>
#include <QVBoxLayout>


class MyWidget : public QWidget
{
Q_OBJECT
public:
    MyWidget(QWidget *parent = 0);
public slots:
    void setValue();
	
private:
	QLineEdit *x1edit;
	QLineEdit *y1edit;
	QLineEdit *x2edit;
	QLineEdit *y2edit;
	QLineEdit *sedit;
	
	QPushButton *automode;
	QPushButton *resetmode;
	QPushButton *gomode;
	
};

MyWidget::MyWidget(QWidget *parent)
    : QWidget(parent)
{
    QVBoxLayout *layout = new QVBoxLayout;
    QGridLayout *grid = new QGridLayout;

    QLabel *x1label = new QLabel(tr("x1="));
    QLabel *y1label = new QLabel(tr("y1="));
    QLabel *x2label = new QLabel(tr("x2="));
    QLabel *y2label = new QLabel(tr("y2="));
    QLabel *slabel = new QLabel(tr("S="));

    x1edit = new QLineEdit;
    y1edit = new QLineEdit;
    x2edit = new QLineEdit;
    y2edit = new QLineEdit;
    sedit = new QLineEdit;

    automode = new QPushButton(tr("Auto"));
    resetmode = new QPushButton(tr("Reset"));
    gomode = new QPushButton(tr("Go!"));

    grid->addWidget(x1label, 0, 0);
    grid->addWidget(y1label, 1, 0);
    grid->addWidget(x2label, 2, 0);
    grid->addWidget(y2label, 3, 0);
    grid->addWidget(slabel, 4, 0);

    grid->addWidget(x1edit, 0, 1);
    grid->addWidget(y1edit, 1, 1);
    grid->addWidget(x2edit, 2, 1);
    grid->addWidget(y2edit, 3, 1);
    grid->addWidget(sedit, 4, 1);

    grid->addWidget(automode, 5, 1);
    grid->addWidget(resetmode, 6, 1);
    grid->addWidget(gomode, 7, 1);

    layout->addLayout(grid);
    setLayout(layout);

    connect(resetmode, SIGNAL(clicked()), x1edit, SLOT(clear()));
    connect(resetmode, SIGNAL(clicked()), y1edit, SLOT(clear()));
    connect(resetmode, SIGNAL(clicked()), x2edit, SLOT(clear()));
    connect(resetmode, SIGNAL(clicked()), y2edit, SLOT(clear()));
    connect(resetmode, SIGNAL(clicked()), sedit, SLOT(clear()));

    connect(automode, SIGNAL(clicked()), this, SLOT(setValue()));
}

void MyWidget::setValue()
{
    x1edit->setText("x1");
    y1edit->setText("y1");
    x2edit->setText("x2");
};

#include "main.moc"

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    MyWidget widget;
    widget.show();
    return app.exec();
}
