
#include <QtGui>
#include "class.h" 

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    QTreeWidget *pTreeWidget = new QTreeWidget( 0); 
    pTreeWidget->setColumnCount(2);
    QStringList headers;
    headers << QObject::tr("Subject") << QObject::tr("Default");
    pTreeWidget->setHeaderLabels( headers); 

    QTreeWidgetItem *pRoot = new QTreeWidgetItem( pTreeWidget);
    pRoot->setText( 0, QObject::tr("Root"));
    
    for( int n = 0; n < 100; n++)
    {
        QTreeWidgetItem *pChild = new QTreeWidgetItem( pRoot);
        pChild->setFlags( pChild->flags() | Qt::ItemIsEditable);
        
        QString sz0 = QObject::tr( "Item %1").arg( n);
        QString sz1 = QObject::tr( "Sub item %1").arg( n);
        pChild->setText(0, sz0);
        pChild->setText(1, sz1);

        pChild->setCheckState(0,Qt::Checked);
    }

    //pTreeWidget->expandItem( pRoot);
    pTreeWidget->collapseItem( pRoot);

    CTest test;																														
    QObject::connect( pTreeWidget, SIGNAL(  itemChanged( QTreeWidgetItem *, int)), &test, SLOT( OnCheckState( QTreeWidgetItem *, int)));
    pTreeWidget->show();

/*
	QLabel	lbl;
	QString	str;
	
	str="<span style=\"background-color: #cef2e0\"><b>Tx:</b> Text</span>" ;
	
	lbl.setText(str);
*/	
    return a.exec();
}
