#include <QtGui>

#include "mainwindow.h"
#include "dragwidget.h"

MainWindow::MainWindow(QWidget *parent)
	:QMainWindow(parent)
{
	setupMenus();
	setupWidgets();
	setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed));
	setWindowTitle(tr("Shablon editor"));
}

void MainWindow::setupMenus()
{
	QMenu *fileMenu = menuBar()->addMenu(tr("&File"));
	
	QAction *exitAction = fileMenu->addAction(tr("E&xit"));
	exitAction->setShortcut(QKeySequence(tr("Ctrl+Q")));
	connect(exitAction, SIGNAL(triggered()) , qApp , SLOT(quit()));

	QMenu *editMenu = menuBar()->addMenu(tr("&Edit"));
	QAction *addText = editMenu->addAction(tr("Add &Text"));
	connect(addText, SIGNAL(triggered()) , qApp , SLOT(addElem()));
}
void MainWindow::setupWidgets()
{
	QFrame *frame = new QFrame;
	QHBoxLayout *frameLayout= new QHBoxLayout(frame);
	
	editor = new DragWidget;
	frameLayout->addWidget(editor);
	
	setCentralWidget(frame);
}