#include <QtGui>

#include "mainwindow.h"
#include "list.h"

MainWindow::MainWindow(QWidget *parent)
	:QMainWindow(parent)
{
	setupMenus();
	setupWidgets();
	setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed));
	setWindowTitle(tr("Shablon editor"));
}

void MainWindow::setupMenus()
{
	QMenu *fileMenu = menuBar()->addMenu(tr("&File"));
	
	QAction *exitAction = fileMenu->addAction(tr("E&xit"));
	exitAction->setShortcut(QKeySequence(tr("Ctrl+Q")));
	
	connect(exitAction, SIGNAL(triggered()) , qApp , SLOT(quit()));
}
void MainWindow::setupWidgets()
{
	QFrame *frame = new QFrame;
	QHBoxLayout *frameLayout= new QHBoxLayout(frame);
	elemList = new List;

	frameLayout->addWidget(elemList);
	setCentralWidget(frame);
}