//
//  Filename:   QPropertyGrid.h
//	Created:	11:11:2007   13:05

#ifndef		__QPropertyGrid_H__
#define		__QPropertyGrid_H__

/*
=========================================================================================

			HEADERS & DEFS

=========================================================================================
*/

#include	"Common.h"
#include	"QProperty.h"

/*
=========================================================================================

			CODE

=========================================================================================
*/

// ** class QPropertyGrid
class QPropertyGrid : public QTreeWidget {

	Q_OBJECT

	// ** cItemDelegate
	class cItemDelegate : public QItemDelegate {
	private:

		uint			height;

	public:
						cItemDelegate( uint _height ) : height( _height ) {}

		QSize sizeHint( const QStyleOptionViewItem& option, const QModelIndex& index ) const  {
			return QSize( 50, height );
		}
	};
/*
	// ** class cGroupDelegate
	class cGroupDelegate : public QItemDelegate {
	private:

		QPaintDevice	*paintDevice;
		uint			height;

	public:
						cGroupDelegate( QPaintDevice *_paintDevice, uint _height )
							: paintDevice( _paintDevice ), height( _height ) {}

		QSize sizeHint( const QStyleOptionViewItem& option, const QModelIndex& index ) const  {
			return QSize( 50, height );
		}

		virtual void	drawDisplay( QPainter *painter, const QStyleOptionViewItem& option, const QRect& rect, const QString& text ) const {
			painter->begin( paintDevice );
			painter->fillRect( rect, QBrush( QColor( 204, 201, 185 ) ) );
			painter->end();
		}
	};
*/
	typedef std::map< QString, QProperty* >	tPropertyMap;
	typedef tPropertyMap::iterator			tPropertyMapIter;

public:

	// ** enum E_TYPE
	enum E_TYPE {
		T_BOOL = 0,
		T_INT,
		T_FLOAT,
		T_STRING,
		T_VECTOR2,
		T_VECTOR3,
		T_COLOR,

		T_TOTAL
	};

	// ** struct sPropertyDef
	struct sPropertyDef {
		QString			name;
		E_TYPE			type;
		void			*pointer;

		union {
			union { int min; float minf; };
			union { int max; float maxf; };

			struct sCaptions {
				char	xCaption[16], yCaption[16], zCaption[16];
			} captions;
		};

						sPropertyDef( void ) : min( 0 ), max( 0 ) {}
	};

private:

	tPropertyMap	properties;

//private:

//	virtual void	drawBranches( QPainter *painter, const QRect& rect, const QModelIndex& index ) const;

public:

					QPropertyGrid( QWidget *parent );

	void			Clear( void );

	void			SetObject( const sPropertyDef *def );

	void			AddBoolProperty( const QString& name, sPropertyDef *def );
	void			AddIntProperty( const QString& name, sPropertyDef *def );
	void			AddFloatProperty( const QString& name, sPropertyDef *def );
	void			AddStringProperty( const QString& name, sPropertyDef *def );
	void			AddVector2Property( const QString& name, sPropertyDef *def );	// float[2]
	void			AddVector3Property( const QString& name, sPropertyDef *def );	// float[3]
	void			AddColorProperty( const QString& name, sPropertyDef *def );

	virtual QSize	sizeHint( void ) const {
		return QSize( parentWidget()->size().width(), parentWidget()->size().height() );
	}
};

#endif		/*	!__QPropertyGrid_H__	*/