//
//  Filename:   QPropertyGrid.cpp
//	Created:	11:11:2007   13:07

/*
=========================================================================================

			HEADERS & DEFS

=========================================================================================
*/

#include	"QPropertyGrid.h"
#include	"QColorWidget.h"

#define		rcast( pointer, to ) reinterpret_cast< to >( pointer )
#define		ccast( pointer, to ) const_cast< to >( pointer )

/*
=========================================================================================

			CODE

=========================================================================================
*/

// ** QPropertyGrid::QPropertyGrid
QPropertyGrid::QPropertyGrid( QWidget *parent ) : QTreeWidget( parent )
{
	setColumnCount( 2 );
	setRootIsDecorated( false );
	setUniformRowHeights( true );
	setDropIndicatorShown( true );
	setAlternatingRowColors( true );
	setItemDelegate( new cItemDelegate( 18 ) );

	header()->setMovable( false );
	header()->resizeSection( 0, (parent->size().width() - 10) / 2 );
	header()->resizeSection( 1, (parent->size().width() - 10) / 2 );

	QTreeWidgetItem *header = headerItem();
	header->setText( 0, "Property" );
	header->setText( 1, "Value" );

	properties.clear();
}
/*
// ** QPropertyGrid::drawBranches
void QPropertyGrid::drawBranches( QPainter *painter, const QRect& rect, const QModelIndex& index ) const {
//	if( index.child( 0, 0 ).isValid() ) {
	QTreeWidget::drawBranches( painter, rect, index );
//	}
}*/

// ** QPropertyGrid::Clear
void QPropertyGrid::Clear( void )
{
	tPropertyMapIter end = properties.end();

	for( tPropertyMapIter i = properties.begin(); i != end; i++ ) {
		delete i->second;
	}

	properties.clear();

	clear();
}

// ** QPropertyGrid::SetObject
void QPropertyGrid::SetObject( const sPropertyDef *def )
{
	_ASSERTE( def != NULL );

	Clear();

	while( def->type != T_TOTAL ) {
		switch( def->type ) {
		case T_BOOL:	AddBoolProperty( def->name, ccast( def, sPropertyDef* ) );		break;
		case T_INT:		AddIntProperty( def->name, ccast( def, sPropertyDef* ) );		break;
		case T_FLOAT:	AddFloatProperty( def->name, ccast( def, sPropertyDef* ) );		break;
		case T_STRING:	AddStringProperty( def->name, ccast( def, sPropertyDef* ) );	break;
		case T_COLOR:	AddColorProperty( def->name, ccast( def, sPropertyDef* ) );		break;
		case T_VECTOR2:	AddVector2Property( def->name, ccast( def, sPropertyDef* ) );	break;
	//	case T_VECTOR3:	AddVector3Property( def->name, rcast( ccast( def->pointer, void* ), cVector3* ) );				break;
		}

		def++;
	}
}

// ** QPropertyGrid::AddBoolProperty
void QPropertyGrid::AddBoolProperty( const QString& name, sPropertyDef *def )
{
	QTreeWidgetItem *item  = new QTreeWidgetItem( this );
	QCheckBox		*check = new QCheckBox( NULL );

	item->setText( 0, name );
	item->setChildIndicatorPolicy( QTreeWidgetItem::ShowIndicator );
	check->setCheckState( ( *( bool* )def->pointer ) ? Qt::Checked : Qt::Unchecked );

	properties[ name ] = new QBoolProperty( ( bool* )def->pointer, check );

	setItemWidget( item, 1, check );
}

// ** QPropertyGrid::AddIntProperty
void QPropertyGrid::AddIntProperty( const QString& name, sPropertyDef *def )
{
	QTreeWidgetItem *item = new QTreeWidgetItem( this );
	QSpinBox		*spin = new QSpinBox( NULL );

	item->setText( 0, name );
	spin->setValue( *( int* )def->pointer );

	if( def->min != def->max ) {
		spin->setRange( def->min, def->max );
	}

	properties[ name ] = new QIntProperty( ( int* )def->pointer, spin );

	setItemWidget( item, 1, spin );
}

// ** QPropertyGrid::AddFloatProperty
void QPropertyGrid::AddFloatProperty( const QString& name, sPropertyDef *def )
{
	QTreeWidgetItem *item = new QTreeWidgetItem( this );
	QDoubleSpinBox	*spin = new QDoubleSpinBox( NULL );

	item->setText( 0, name );
	spin->setValue( *( float* )def->pointer );

	properties[ name ] = new QFloatProperty( ( float* )def->pointer, spin );

	setItemWidget( item, 1, spin );

	QTreeWidgetItem *child = new QTreeWidgetItem( item );
	child->setText( 0, name );
}

// ** QPropertyGrid::AddStringProperty
void QPropertyGrid::AddStringProperty( const QString& name, sPropertyDef *def )
{
	QTreeWidgetItem *item = new QTreeWidgetItem( this );
	QLineEdit		*edit = new QLineEdit( NULL );

	item->setText( 0, name );
	edit->setText( ((std::string*)def->pointer)->c_str() );

	properties[ name ] = new QStringProperty( ( std::string* )def->pointer, edit );

	setItemWidget( item, 1, edit );
}

// ** QPropertyGrid::AddVector2Property
void QPropertyGrid::AddVector2Property( const QString& name, sPropertyDef *def )
{
	QTreeWidgetItem *item  = new QTreeWidgetItem( this );
	QLabel			*label = new QLabel( NULL );
	QString			strX = QString( "%1" ).arg( (( float* )def->pointer)[0] );
	QString			strY = QString( "%1" ).arg( (( float* )def->pointer)[1] );
	QString			xCap = QString( def->captions.xCaption );
	QString			yCap = QString( def->captions.yCaption );

	item->setText( 0, name );
	label->setText( "(" + (( xCap == "" ) ? "x" : xCap) + "=" + strX + "," + (( yCap == "" ) ? "y" : yCap) + "=" + strY + ")" );

	setItemWidget( item, 1, label );
//	setItemDelegateForRow( -1, new cGroupDelegate( ( QPaintDevice* )this, 18 ) );

	// ** X coord
	QTreeWidgetItem *itemX = new QTreeWidgetItem( item );
	QLineEdit *editX = new QLineEdit( NULL );
	
	itemX->setText( 0, (( xCap == "" ) ? "x" : xCap) );
	editX->setText( strX );

	setItemWidget( itemX, 1, editX );

	// ** Y coord
	QTreeWidgetItem *itemY = new QTreeWidgetItem( item );
	QLineEdit *editY = new QLineEdit( NULL );

	itemY->setText( 0, (( yCap == "" ) ? "y" : yCap) );
	editY->setText( strY );

	setItemWidget( itemY, 1, editY );

	properties[ name ] = new QVector2Property( ( float* )def->pointer, editX, editY );
}

// ** QPropertyGrid::AddColorProperty
void QPropertyGrid::AddColorProperty( const QString& name, sPropertyDef *def )
{
	QTreeWidgetItem *item  = new QTreeWidgetItem( this );
	QColorWidget	*clr   = new QColorWidget( NULL );
	byte			*color = ( byte* )def->pointer;

	item->setText( 0, name );
	clr->Update( QColor( color[0], color[1], color[2], color[3] ) );

	properties[ name ] = new QColorProperty( ( byte* )def->pointer, clr );

	setItemWidget( item, 1, clr );
}