//
//  Filename:   QProperty.h
//	Created:	11:11:2007   14:31

#ifndef		__QProperty_H__
#define		__QProperty_H__

/*
=========================================================================================

			HEADERS & DEFS

=========================================================================================
*/

#include	"Common.h"

/*
=========================================================================================

			CODE

=========================================================================================
*/

class QColorWidget;

// ** class QProperty
class QProperty : public QObject {
public:

	virtual		~QProperty( void ) {}
};

// ** class QIntProperty
class QIntProperty : public QProperty {

	Q_OBJECT

private:

	int				*pointer;
	QSpinBox		*spin;

private slots:

	void			OnValueChanged( int value );

public:

					QIntProperty( int *pointer, QSpinBox *_spin );
	virtual			~QIntProperty( void ) {}
};

// ** class QFloatProperty
class QFloatProperty : public QProperty {

	Q_OBJECT

private:

	float			*pointer;
	QDoubleSpinBox	*spin;

private slots:

	void			OnValueChanged( double value );

public:

					QFloatProperty( float *pointer, QDoubleSpinBox *_spin );
	virtual			~QFloatProperty( void ) {}
};

// ** class QBoolProperty
class QBoolProperty : public QProperty {

	Q_OBJECT

private:

	bool			*pointer;
	QCheckBox		*check;

private slots:

	void			OnValueChanged( int index );

public:

					QBoolProperty( bool *pointer, QCheckBox *_check );
	virtual			~QBoolProperty( void ) {}
};

// ** class QStringProperty
class QStringProperty : public QProperty {

	Q_OBJECT

private:

	std::string		*pointer;
	QLineEdit		*edit;

private slots:

	void			OnValueChanged( const QString& text );

public:

					QStringProperty( std::string *object, QLineEdit *_edit );
	virtual			~QStringProperty( void ) {}
};

// ** class QVector2Property
class QVector2Property : public QProperty {

	Q_OBJECT

private:

	float			*pointer;
	QLineEdit		*editX, *editY;

private slots:

	void			OnValueChangedX( const QString& text );
	void			OnValueChangedY( const QString& text );

public:

					QVector2Property( float *pointer, QLineEdit *editX, QLineEdit *editY );
	virtual			~QVector2Property( void ) {}
};

// ** class QColorProperty
class QColorProperty : public QProperty {

	Q_OBJECT

private:

	byte			*pointer;
	QColorWidget	*color;

private slots:

	void			OnSelectColor( bool checked );

public:

					QColorProperty( byte *pointer, QColorWidget *combo );
	virtual			~QColorProperty( void ) {}
};


#endif		/*	!__QProperty_H__	*/