//
//  Filename:   QProperty.cpp
//	Created:	11:11:2007   14:59

/*
=========================================================================================

			HEADERS & DEFS

=========================================================================================
*/

#include	"QProperty.h"
#include	"QColorWidget.h"

/*
=========================================================================================

			CODE

=========================================================================================
*/

// ------------------------ QFloatProperty ------------------------ //

// ** QFloatProperty::QFloatProperty
QFloatProperty::QFloatProperty( float *_pointer, QDoubleSpinBox *_spin ) : spin( _spin ), pointer( _pointer ) {
	connect( spin, SIGNAL( valueChanged(double) ), this, SLOT( OnValueChanged(double) ) );
	_ASSERTE( pointer != NULL );
}

// ** QFloatProperty::OnValueChanged
void QFloatProperty::OnValueChanged( double value ) {
	*pointer = ( float )value;
}

// ------------------------ QBoolProperty ------------------------ //

// ** QBoolProperty::QBoolProperty
QBoolProperty::QBoolProperty( bool *_pointer, QCheckBox *_check ) : check( _check ), pointer( _pointer ) {
	connect( check, SIGNAL( stateChanged(int) ), this, SLOT( OnValueChanged(int) ) );
	_ASSERTE( pointer != NULL );
}

// ** QBoolProperty::OnValueChanged
void QBoolProperty::OnValueChanged( int value ) {
	*pointer = ( value ) ? true : false;
}

// ------------------------ QIntProperty ------------------------ //

// ** QIntProperty::QIntProperty
QIntProperty::QIntProperty( int *_pointer, QSpinBox *_spin ) : spin( _spin ), pointer( _pointer ) {
	connect( spin, SIGNAL( valueChanged(int) ), this, SLOT( OnValueChanged(int) ) );
	_ASSERTE( pointer != NULL );
}

// ** QIntProperty::OnValueChanged
void QIntProperty::OnValueChanged( int value ) {
	*pointer = value;
}

// ------------------------ QStringProperty ------------------------ //

// ** QStringProperty::QStringProperty
QStringProperty::QStringProperty( std::string *_pointer, QLineEdit *_edit ) : edit( _edit ), pointer( _pointer ) {
	connect( edit, SIGNAL( textChanged(const QString&) ), this, SLOT( OnValueChanged(const QString&) ) );
	_ASSERTE( pointer != NULL );
}

// ** QStringProperty::OnValueChanged
void QStringProperty::OnValueChanged( const QString& text ) {
	*pointer = std::string( text.toAscii() );
}

// ------------------------ QVector2Property ------------------------ //

// ** QVector2Property::QVector2Property
QVector2Property::QVector2Property( float *_pointer, QLineEdit *_editX, QLineEdit *_editY )
	: editX( _editX ), editY( _editY ), pointer( _pointer ) {
	connect( editX, SIGNAL( textChanged(const QString&) ), this, SLOT( OnValueChangedX(const QString&) ) );
	connect( editY, SIGNAL( textChanged(const QString&) ), this, SLOT( OnValueChangedY(const QString&) ) );
	_ASSERTE( pointer != NULL );
}

// ** QVector2Property::OnValueChangedX
void QVector2Property::OnValueChangedX( const QString& text ) {
	pointer[0] = text.toFloat();
}

// ** QVector2Property::OnValueChangedY
void QVector2Property::OnValueChangedY( const QString& text ) {
	pointer[1] = text.toFloat();
}

// ------------------------ QColorProperty ------------------------ //

// ** QColorProperty::QColorProperty
QColorProperty::QColorProperty( byte *_pointer, QColorWidget *_color )
	: color( _color ), pointer( _pointer ) {
	connect( color, SIGNAL( clicked(bool) ), this, SLOT( OnSelectColor(bool) ) );
	_ASSERTE( pointer != NULL );
}

// ** QColorProperty::OnSelectColor
void QColorProperty::OnSelectColor( bool checked )
{
	QColor c = QColorDialog::getColor();

	if( !c.isValid() ) {
		return;
	}

	color->Update( c );

	pointer[0] = c.red();
	pointer[1] = c.green();
	pointer[2] = c.blue();
	pointer[3] = c.alpha();
}