//
//  Filename:   QColorWidget.cpp
//	Created:	27:10:2007   20:46

/*
=========================================================================================

			HEADERS & DEFS

=========================================================================================
*/

#include	"QColorWidget.h"

/*
=========================================================================================

			CODE

=========================================================================================
*/

// ** QColorWidget::QColorWidget
QColorWidget::QColorWidget( QWidget *parent ) : QPushButton( parent ) {}

// ** QColorWidget::paintEvent
void QColorWidget::paintEvent( QPaintEvent *event )
{
	QPainter painter;
	QBrush	 brush;
	const QRect& eventRect = event->rect();
	QRect	 rect = QRect( eventRect.x() + 1, eventRect.y() + 1, eventRect.width() - 1, eventRect.height() - 2 );

	brush.setStyle( Qt::SolidPattern );
	brush.setColor( color );

	painter.begin( this );
	painter.fillRect( rect, brush );
	painter.end();
}

// ** QColorWidget::Update
void QColorWidget::Update( const QColor& _color )
{
	color = _color;
	update();
}