#include "SomeWidget.h"
#include "SomeWidgetPlugin.h"

#include <QtPlugin>

SomeWidgetPlugin::SomeWidgetPlugin(QObject *parent)
    : QObject(parent)
{
    initialized = false;
}

void SomeWidgetPlugin::initialize(QDesignerFormEditorInterface * /* core */)
{
    if (initialized)
        return;

    initialized = true;
}

bool SomeWidgetPlugin::isInitialized() const
{
    return initialized;
}

QWidget *SomeWidgetPlugin::createWidget(QWidget *parent)
{
	return new SomeWidget(parent);
}

QString SomeWidgetPlugin::name() const
{
    return "SomeWidget";
}

QString SomeWidgetPlugin::group() const
{
	return tr("SOME Widget for Application");
}

QIcon SomeWidgetPlugin::icon() const
{
	return QIcon();
}

QString SomeWidgetPlugin::toolTip() const
{
	return tr("SomeWidget");
}

QString SomeWidgetPlugin::whatsThis() const
{
	return tr("This widget is destiny in LineEdit");
}

bool SomeWidgetPlugin::isContainer() const
{
	return false;
} 

QString SomeWidgetPlugin::domXml() const
{
	return "<widget class=\"SomeWidget\" name=\"SomeWidget\">\n"
		"</widget>\n";
}

QString SomeWidgetPlugin::includeFile() const
{
    return "SomeWidget.h";
}


Q_EXPORT_PLUGIN2(someWidgetPlugin, SomeWidgetPlugin)
