#include "MyWidget.h"
#include "ui_MyWidget.h"

//класс своего обработчика прокрутки
class CMyScrollHandler:public QObject
{
	//"опекаемый" QScrollArea
	const QScrollArea* scrollArea=0;
public:
	CMyScrollHandler(QScrollArea* scrollArea)
		:QObject(scrollArea)
		,scrollArea(scrollArea)
	{
		//ставим фильтр на виджет самой области прокрутки-
		//для сброса фокуса с чайлда, когда крутят колесом по области
		if(scrollArea->widget())
		{
			scrollArea->widget()->installEventFilter(this);
		}

		//установка фильтров на чайлды нужных классов
		installHandlerToChilds<QComboBox>();
		installHandlerToChilds<QSpinBox>();
		//...
	}

private:
	//установки фильтра на чайлды определённого типа
	template<class ControlType>
	void installHandlerToChilds()
	{
		if(!scrollArea)return;

		//для всех чайлдов подходящего типа
		auto list=scrollArea->widget()->findChildren<ControlType*>(QString(), Qt::FindChildrenRecursively);
		for(auto* child:list)
		{
			//ставим фокус только по клику или тАбу
			child->setFocusPolicy(Qt::StrongFocus);

			//установка обработчика
			child->installEventFilter(this);
		}
	}

	//фильтр
	bool eventFilter(QObject* target, QEvent* event)override
	{
		do
		{
			if(event->type()!= QEvent::Wheel)
			{
				//остальные сообщения нас тут не интересуют
				break;
			}

			if(auto* control=dynamic_cast<QWidget*>(target))
			{
				//если крутят колесо на области прокрутки,
				if(control==scrollArea->widget())
				{
					//то скидываем фокус с чайлда, если таковой имеется
					if(auto* w=control->focusWidget())
					{
						//control->setFocus();
						w->clearFocus();
					}

					//дальше обычная обработка
					break;
				}

				//если крутят колесо на чайлде, который сейчас не в фокусе,
				if(!control->hasFocus())
				{
					//то не разрешаем обработку колеса
					return true;
				}

				//а иначе - обычная обработка
			}
		}
		while(0);

		//обычная обработка
		return QObject::eventFilter(target, event);
	}
};

MyWidget::MyWidget(QWidget* parent)
	:QDialog(parent,Qt::Dialog)
	,ui(new Ui::MyWidget)
{
	ui->setupUi(this);
	setWindowFlags(windowFlags()&~Qt::WindowContextHelpButtonHint);

	//создаём фильтрующий объект для виджета ui->scrollArea
	new CMyScrollHandler(ui->scrollArea);
}

MyWidget::~MyWidget()
{
	delete ui;
}
