#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    graphics();

    connect(ui->customPlot, SIGNAL(plottableClick(QCPAbstractPlottable*,QMouseEvent*)),
            this, SLOT(graphClicked(QCPAbstractPlottable*)));

}


void MainWindow::graphics()
{
    ui->customPlot->setInteractions(QCP::iRangeDrag | QCP::iRangeZoom | QCP::iSelectPlottables);
    ui->customPlot->axisRect()->setRangeDrag(Qt::Vertical);   // peremeshenie po OY
    ui->customPlot->axisRect()->setRangeZoom(Qt::Vertical);   // mashtab po OX

    ui->customPlot->addGraph(ui->customPlot->xAxis, ui->customPlot->yAxis);
    ui->customPlot->addGraph(ui->customPlot->xAxis, ui->customPlot->yAxis);
    ui->customPlot->addGraph(ui->customPlot->xAxis, ui->customPlot->yAxis);

    ui->customPlot->graph(0)->setLineStyle(QCPGraph::lsLine);
    ui->customPlot->graph(1)->setLineStyle(QCPGraph::lsLine);
    ui->customPlot->graph(2)->setLineStyle(QCPGraph::lsLine);

    ui->customPlot->graph(0)->setPen(QPen(Qt::red, 3));
    ui->customPlot->graph(1)->setPen(QPen(Qt::yellow, 3));
    ui->customPlot->graph(2)->setPen(QPen(Qt::green, 3));

    ui->customPlot->xAxis->setVisible(true);
    ui->customPlot->yAxis->setVisible(false);
    ui->customPlot->xAxis2->setVisible(false);
    ui->customPlot->yAxis2->setVisible(false);

    ui->customPlot->xAxis->setBasePen(QPen(Qt::black));
    ui->customPlot->yAxis->setBasePen(QPen(Qt::black));
    ui->customPlot->xAxis2->setBasePen(QPen(Qt::black));
    ui->customPlot->yAxis2->setBasePen(QPen(Qt::black));

    QVector<double> x(250), y1(250), y2(250), y3(250);
    for (int i=0; i<250; ++i)
    {
        x[i] = i;
        y1[i] = sin(x[i]/10);
        y2[i] = sin(x[i]/7) + 1.0;
        y3[i] = cos(x[i]/5) + 2.0;
    }

//    connect(ui->customPlot->xAxis, SIGNAL(rangeChanged(QCPRange)), ui->customPlot->xAxis2, SLOT(setRange(QCPRange)));
//    connect(ui->customPlot->yAxis, SIGNAL(rangeChanged(QCPRange)), ui->customPlot->yAxis2, SLOT(setRange(QCPRange)));

    ui->customPlot->graph(0)->setData(x, y1);
    ui->customPlot->graph(1)->setData(x, y2);
    ui->customPlot->graph(2)->setData(x, y3);

    ui->customPlot->graph(0)->setName("graph 0");
    ui->customPlot->graph(1)->setName("graph 1");
    ui->customPlot->graph(2)->setName("graph 2");

    ui->customPlot->rescaleAxes();

    ui->customPlot->replot();
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::graphClicked(QCPAbstractPlottable *plottable)
{
  ui->statusBar->showMessage(QString("Clicked on graph '%1'.").arg(plottable->name()), 1000);

  qDebug() << plottable->name();


  if (plottable->name() == "graph 0")
  {
      ui->customPlot->yAxis->setVisible(true);

      ui->customPlot->graph(0)->setKeyAxis(ui->customPlot->xAxis);
      ui->customPlot->graph(0)->setValueAxis(ui->customPlot->yAxis);

      ui->customPlot->graph(1)->setKeyAxis(ui->customPlot->xAxis2);
      ui->customPlot->graph(1)->setValueAxis(ui->customPlot->yAxis2);
      ui->customPlot->graph(2)->setKeyAxis(ui->customPlot->xAxis2);
      ui->customPlot->graph(2)->setValueAxis(ui->customPlot->yAxis2);


      ui->customPlot->yAxis->setAutoTicks(false);
      ui->customPlot->yAxis->setAutoTickLabels(false);
      ui->customPlot->yAxis->setAutoSubTicks(false);
      ui->customPlot->yAxis->setTickVector(QVector<double>()
                                           << 1.0 << 2.0 << 3.0);
      ui->customPlot->yAxis->setTickVectorLabels(QVector<QString>()
                                                 << "1,0" << "2,0" << "3,0");

      ui->customPlot->rescaleAxes();
      ui->customPlot->replot();
  }

  if (plottable->name() == "graph 1")
  {
      ui->customPlot->graph(1)->setKeyAxis(ui->customPlot->xAxis);
      ui->customPlot->graph(1)->setValueAxis(ui->customPlot->yAxis);

      ui->customPlot->graph(0)->setKeyAxis(ui->customPlot->xAxis2);
      ui->customPlot->graph(0)->setValueAxis(ui->customPlot->yAxis2);
      ui->customPlot->graph(2)->setKeyAxis(ui->customPlot->xAxis2);
      ui->customPlot->graph(2)->setValueAxis(ui->customPlot->yAxis2);

  }


}
