#include "dialog.h"
#include "node.h"
//#include "edge.h"
#include <QStaticText>

Node::Node()
{
    Pressed = false;
    setFlag(ItemIsMovable);

}

QRectF Node::boundingRect() const
{
    return QRectF(0, 0, 40, 40);
}

void Node::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{
    QRectF rec = boundingRect();
    QBrush brush(Qt::blue);
    QPen bluepen(Qt::blue);
    bluepen.setWidth(3);
    QPen redpen(Qt::red);
    redpen.setWidth(3);
    if (Pressed)
    {
        brush.setColor(Qt::red);
        painter->setPen(redpen);
    }
    else
    {
        brush.setColor(Qt::blue);
        painter->setPen(bluepen);
    }


//    painter->fillRect(rec, brush);
//    painter->drawRect(rec);
    painter->drawEllipse(rec);

    QString n = QString::number(v);

    painter->drawText (rec, Qt::AlignCenter | Qt::AlignVCenter, n);
}

void Node::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    Pressed = true;
    update();
    QGraphicsItem::mousePressEvent(event);
}

void Node::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
{

    xnode = x() + 20;
    ynode =  y() + 20;
    Pressed = false;
    update();
    QGraphicsItem::mouseReleaseEvent(event);
}
