#ifndef EDGE_H
#define EDGE_H
#include <QPainter>
#include <QGraphicsItem>
#include <QDebug>

class Edge : public QGraphicsItem
{
public:
    Edge();

    int EdgeWeightInt;
    QString EdgeWeight;

    QRectF boundingRect() const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);
    bool Pressed;

    float angle, temp;
    int SourceNode, DestinNode;
    float xstart, ystart, xend, yend;
    float leftangleX, leftangleY, rightangleX, rightangleY;



    float textposX, textposY;
protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);
};

#endif // EDGE_H
