#include "edge.h"

Edge::Edge()
{
    Pressed = false;
    //    setFlag(ItemIsMovable);
}

QRectF Edge::boundingRect() const
{
    return QRectF (100, 100, 100, 100);
}

void Edge::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{
    QRectF rec = boundingRect();

    QBrush graybrush;
    graybrush.setColor(Qt::darkGray);
    graybrush.setStyle(Qt::SolidPattern);

    QPen redpen(Qt::red);
    redpen.setWidth(2);

    QPen graypen(Qt::darkGray);
    graypen.setWidth(2);

    QPolygon arrow;
    angle = 0;

    arrow << QPoint (leftangleX, leftangleY);
    arrow << QPoint (xend, yend);
    arrow << QPoint (rightangleX, rightangleY);

    QPainterPath path;
    path.addPolygon(arrow);

    painter->setPen(graypen);
    painter->drawLine(xstart, ystart, xend, yend);

    painter->drawPolygon(arrow);
    painter->fillPath(path, graybrush);


    painter->setPen(redpen);
    QString EdgeWeight = QString::number(EdgeWeightInt);

    painter->drawText ( textposX, textposY, EdgeWeight);

}

void Edge::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    /*    Pressed = true;
        update();
        QGraphicsItem::mousePressEvent(event);
    */
}

void Edge::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
{
    /*    Pressed = false;
        update();
        QGraphicsItem::mouseReleaseEvent(event);
    */
}
