#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "stdlib.h"
#include "time.h"
#include "QDebug"
#include "math.h"
#include <QGraphicsScene>

float chi2inv(float a, int n);
MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    n=6;
    pi=M_PI;
}

MainWindow::~MainWindow()
{
    delete ui;
}

float MainWindow::r()
{
    float r= (float) rand() / RAND_MAX;
    return r;
}

void MainWindow::on_pushButton_clicked()
{
    srand(time(NULL));
    r_count=ui->sb_r_count->value();//  
    mx=ui->dsb_mx->value();// 
    dx=ui->dsb_dx->value();//  
    z.clear();
    x.clear();
    v.clear();
    fi.clear();
    fp.clear();
    xi.clear();
    xip.clear();
    for(int i=0;i<r_count;i++)//    
        for(int j=0;j<n;j++) //   
        {
            if (j==0) v.append(r()); //        v  r
            else v[i]+=r();//         r
        }
    for(int i=0;i<r_count;i++)//    
    {
        z.append((v[i]-(n/2.0))/sqrt(n/12.0));//   
    }
    for(int i=0;i<r_count;i++)//    
    {
        x.append(mx+z[i]*dx); //  
    }

    for(int i=0;i<r_count;i++)//    
    {
        int j=fi.indexOf((int)(x[i]*10));

        if(j==-1)
        {
            fi.append((int)(x[i]*10));

            fp.append(1);
        }
        else
        {
            fp[j]+=1;
        }
    }
    for(int i=0;i<fi.count();i++)//    
    {
        qDebug()<<" :"<<fi[i]<<" : "<<fp[i];
    }
    int count=0;
    for(int i=0;i<fi.count();i++)//    
    {
        count+=fp[i];
    }
    qDebug()<<"Itogo: "<<count;
    this->update();

    float pi2=sqrt(2.0*pi);
    for(float i=(mx-4*dx);i<=(mx+4*dx);i+=0.1)


    {
        xi.append(i*10);

        xip.append((1.0/(dx*pi2))*exp(-((i-mx)*(i-mx))/(2.0*dx*dx)));
    }

    QGraphicsScene *scena=new QGraphicsScene;


    scena->addLine(200,150,200,0,QPen(Qt::black));
    scena->addLine(0,150,600,150,QPen(Qt::black));
    for(int i=0;i<61;i++)
        {
            scena->addLine(i*10,150-5,i*10,150+5,QPen(Qt::black));
        }
    for(int i=0;i<31;i++)
        {
            scena->addLine(i*100,150-10,i*100,150+10,QPen(Qt::black));
        }
        for(int i=0;i<fi.count();i++)
        {

            scena->addEllipse(200+fi[i],150-10000*fp[i]/r_count,1,1,QPen(Qt::black));

        }
        for(int i=0;i<xi.count();i++)
        {
            scena->addEllipse(200+xi[i],150-xip[i]*1000,1,1,QPen(Qt::red));
        }
        xiexp=0.0;
        int countxi=xi.count();
        int ix=0;
        float rc=(float)r_count;


        for(ix=0;ix<countxi;ix++)
        {
            int jf=0;
            while(xi[ix]!=fi[jf] && jf<fi.count()-1){jf++;}

                xiexp+=0.1*((fp[jf]-xip[ix]*r_count)*(fp[jf]-xip[ix]*r_count))/((xip[ix])*r_count);

        }

        ui->label_3->setText(QString::number(xiexp));
 ui->graphicsView->setScene(scena);

 float min=chi2inv(1-0.01,r_count-3);
 float min25=chi2inv(1-0.25,r_count-3);
 float mid=chi2inv(1-0.5,r_count-3);
 float mid75=chi2inv(1-0.75,r_count-3);
 float max=chi2inv(1-0.999,r_count-3);


ui->label_4->setText(QString::number(mid));
 ui->label_5->setText(QString::number(max));
 ui->label_10->setText(QString::number(min));
 ui->label_12->setText(QString::number(min25));
 ui->label_14->setText(QString::number(mid75));


}

float chi2inv(float a, int n) {
    float d;
    if(a >= 0.001 && a < 0.5)
        d = - 2.0637 * pow((log(1.0/a) - 0.16), 0.4274) + 1.5774;
    else if(a <= 0.999)
        d = 2.0637 * pow((log(1.0/(1 - a)) - 0.16), 0.4274) - 1.5774;
    else
        return 0;
    float A = d * sqrt(2);
    float B = 2.0/3 * (d * d - 1);
    float C = d * (d * d - 7)/(9 * sqrt(2));
    float D = (6 * pow(d, 4) + 14 * d * d - 32)/405;
    float E = d * (9 * pow(d, 4) + 256 * d * d - 433) / (4860 * sqrt(2));
    return n + A * sqrt(n) + B + C/sqrt(n) + D/n + E/(n*sqrt(n));
}
