#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QSqlQuery>


MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::Init()
{
    this->db = QSqlDatabase::addDatabase("QSQLITE");
    this->db.setDatabaseName(":memory:");
    this->db.open();

    this->db.exec("CREATE TABLE parameter_source"
                  "(id_unit INTEGER PRIMARY KEY AUTOINCREMENT,"
                  "name TEXT, "
                  "definition TEXT)");

    QSqlQuery qry (this->db);
    qry.prepare("INSERT INTO parameter_source (id_unit, name, definition)"
                "VALUES (:id_unit, :name, :definition);");
    qry.bindValue(":id_unit", QVariant ());
    qry.bindValue(":name", "Hello");
    qry.bindValue(":definition", "There");
    qry.exec();

    qry.bindValue(0, QVariant ());
    qry.bindValue(1, "Hello");
    qry.bindValue(2, "There");
    qry.exec();

    this->mdl =  new QSqlTableModel (this, this->db);
    this->mdl->setTable("parameter_source");
    this->mdl->select();

    this->ui->tableView->setModel(this->mdl);
}
