#include <boost/date_time.hpp>
#include <boost/interprocess/sync/scoped_lock.hpp>
#include "threadedlist.h"

using namespace boost::interprocess;

ThreadedList::ThreadedList()
{
}

ThreadedList::~ThreadedList()
{
}

JobData ThreadedList::getJob()
{
    scoped_lock<boost::mutex> locker(m_mutex);
    for (JobData jb : m_jobList) {
        if ((jb.jobState == JS_NEW) ||
                        (((jb.jobState == JS_PAUSED) || (jb.jobState == JS_WARCHIVE))
                         && ((jb.lastExecTime + jb.retryTimeout) < 0 /** @todo FIXME current time m_sec from epoch*/))) {
             jb.jobState = (jb.jobState == JS_WARCHIVE) ? JS_CHECKINGWA : JS_CHECKING;
             return jb;
        }
    }
    JobData job;
    job.jobId = string("empty");
    return job;
}

bool ThreadedList::addJob(const JobData job)
{
    scoped_lock<boost::mutex> locker(m_mutex);
/*    if (job.in.(string(".partial")))
        return false;*/ /** @todo TODO .partial endsWith*/
    for (JobData jb : m_jobList) {
        if (jb.in == job.in)
            return false;
    }
    m_jobList.push_back(job);
    return true;
}

bool ThreadedList::addJob(const string job)
{
    scoped_lock<boost::mutex> locker(m_mutex);
    m_jobLst.push_back(job);
}

void ThreadedList::updateJob(const JobData job)
{
    scoped_lock<boost::mutex> locker(m_mutex);
    for (JobData jb : m_jobList) {
        if (jb.jobId == job.jobId) {
            jb.lastExecTime = job.lastExecTime;
            jb.retryCount = job.retryCount;
            jb.jobState = job.jobState;
            return;
        }
    }
}
