#include <boost/chrono.hpp>
#include <boost/date_time.hpp>
#include "taskmanager.h"
#include "taskexecuter.h"

using namespace std;
using namespace boost;

//#define BOOST_THREAD_VERSION 2

TaskManager::TaskManager()
{
}

TaskManager::~TaskManager()
{
    m_threadGroup.interrupt_all();
}

void TaskManager::start()
{
    ThreadedList lst;
    for (int i = 0; i < 5; ++i) {
        TaskExecuter tex(i);
        tex.setList(&lst);
        m_threadGroup.create_thread(tex);
    }

    chrono::duration<uint32_t, milli> d(1000);
    for (int i = 0; i < 5; i++) {
        cout << "std called\n\r";
        this_thread::sleep_for(d);
    }

    for (auto str : lst.data()) {
        cout << str;
    }
}
