#ifndef COMMONTYPES_H
#define COMMONTYPES_H

#include <iostream>
#include <boost/atomic.hpp>
#include <boost/uuid/uuid_io.hpp>
#include <boost/uuid/uuid_generators.hpp>

using namespace std;
using namespace boost;

enum JobState {
    JS_NEW          = 0,
    JS_PAUSED       = 1,
    JS_CANCELLED    = 2,
    JS_DONE         = 3,
    JS_CHECKING     = 4,
    JS_WARCHIVE     = 5,
    JS_CHECKINGWA   = 6,
    JS_FILENOTFOUND = 7
};

struct JobData {
    string    jobId;
    JobState  jobState;
    string    in;
    string    out;
    string    arc;
    uint64_t  retryCount;
    uint64_t  maxRetryCount;
    uint64_t  lastExecTime;
    uint64_t  retryTimeout;

    JobData() :
        jobId(uuids::to_string(uuids::random_generator()())),
        jobState(JS_NEW),
        in(""),
        out(""),
        arc(""),
        retryCount(0),
        maxRetryCount(5),
        lastExecTime(1),
        retryTimeout(10000)
    {}

    JobData(const JobData &jd) :
        jobId(jd.jobId),
        jobState(jd.jobState),
        in(jd.in),
        out(jd.out),
        arc(jd.arc),
        retryCount(jd.retryCount),
        maxRetryCount(jd.maxRetryCount),
        lastExecTime(jd.lastExecTime),
        retryTimeout(jd.retryTimeout)
    {}

    JobData& operator=(const JobData &jd)
    {
        if (this == &jd)
            return *this;
        jobId         = jd.jobId;
        jobState      = jd.jobState;
        in            = jd.in;
        out           = jd.out;
        arc           = jd.arc;
        retryCount    = jd.retryCount;
        maxRetryCount = jd.maxRetryCount;
        lastExecTime  = jd.lastExecTime;
        retryTimeout  = jd.retryTimeout;
        return *this;
    }

    bool operator==(const JobData &second) const
    {
        return (jobId == string("empty") || second.jobId == string("empty")) ? false : jobId == second.jobId;
    }
};

#endif // COMMONTYPES_H
