# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui, uic
import math
import os
import struct
import time

phi = 0.0
timer = QtCore.QTimer()
#im = QtGui.QImage(720, 492, QtGui.QImage.Format_ARGB32)
im = QtGui.QImage(720, 6, QtGui.QImage.Format_ARGB32)

class ld(QtGui.QDialog):
    def __init__(self, parent=None):
        super(ld, self).__init__(parent)
        self.ui = uic.loadUi("ld.ui", self)

        self.connect(timer, QtCore.SIGNAL("timeout()"), self.MyTimer)
        #timer.start((0.05 * 1000) / 60)
        timer.start(1)

    def paintEvent(self, QPaintEvent):
        if self.ui.radioButton.isChecked():
            painterRect = QtGui.QPainter(self)
            painterRect.setBrush(QtGui.QColor('black'))
            painterRect.drawRect(50, 50, 720, 492)

            self.MyDraw()

        self.update()

    def MyRadianToGradus(self, phiedit):
        gradus = phiedit * 360 / (2 * math.pi)
        return gradus

    def MyGradusToRadian(self, phiedit):
        radian = phiedit * 2 * math.pi / (360)
        return radian

    def MyTimer(self):
        global phi
        global im

        if self.ui.radioButton.isChecked():
            self.start = time.time()
            for j in range(0, 720, 1):
                #for i in range(491, -1, -1):
                for i in range(5, -1, -1):
                    im.setPixel(j, i, QtGui.QColor(255, 0, 0, 255).rgba())

            self.end = time.time()
            self.secs = self.end - self.start
            print self.secs * 1000  # миллисекунды

            self.update()

        if int(self.MyRadianToGradus(phi) + 0.5) * 720 / 360 < 720:
            phi += self.MyGradusToRadian(6.0)
        else:
            phi = self.MyGradusToRadian(6.0)

    def MyDraw(self):
        global im
        global phi

        Tochka = QtGui.QPainter()
        Tochka.begin(self)

        Tochka.translate(50, 50)

        Tochka.drawImage(0, 0, im, 0, 0, int((2 * self.MyRadianToGradus(phi)) + 0.5), 492)

        Tochka.end()

if __name__ == '__main__':
    import sys

    app = QtGui.QApplication(sys.argv)

    window = ld()
    window.show()

    sys.exit(app.exec_())