#include <QtCore>

#include "mymodel.h"


myModel::myModel(QObject *parent)
	: QAbstractItemModel(parent)
{
	rootNode = 0;
}

myModel::~myModel()
{
}

void myModel::setRootNode(CSharedV *node)
{
    rootNode = node;
    
/*	
	rootNode = new CSharedV();
	rootNode->m_nType = stObject;
	rootNode->m_Properties["{E27B55A3-1282-44A0-A35E-6F3214FDB97B}"] = node;
	node->m_pOwner = rootNode; 
*/
	reset();
}

QModelIndex myModel::index(int row, int column,
								   const QModelIndex &parent) const
{
    if (!rootNode)
        return QModelIndex();
    /*if (!hasIndex(row, column, parent))
        return QModelIndex();*/

	CSharedV *parentNode = nodeFromIndex(parent);
	CSharedV *childNode = childFromParent(parentNode, row);
	if (childNode) 
		return createIndex(row, column, childNode);
	else
		return QModelIndex();
}

int myModel::rowCount(const QModelIndex &parent) const
{
	CSharedV *parentNode = nodeFromIndex(parent);
    if (!parentNode)
        return 0;
	return parentNode->propCount();
}

int myModel::columnCount(const QModelIndex & /* parent */) const
{
    return 2;
}

QVariant myModel::data(const QModelIndex &index, int role) const
{
    if (role != Qt::DisplayRole)
        return QVariant();

	CSharedV *node = nodeFromIndex(index);
    if (!node)
        return QVariant();
	else if (index.column() == 0) 
		return node->getName();
	else if (index.column() == 1)
		return node->asDebugString();
	else	
		return QVariant();
}

QModelIndex myModel::parent(const QModelIndex &child) const
{
	CSharedV *node = nodeFromIndex(child);
    if (!node)
        return QModelIndex();
	CSharedV *parentNode = node->getOwner();
    if (!parentNode)
        return QModelIndex();
    CSharedV *grandparentNode = parentNode->getOwner();
    if (!grandparentNode)
        return QModelIndex();

	int row = grandparentNode->indexOf(parentNode); 
	if (row == -1) 
		return QModelIndex();
    return createIndex(row, child.column(), parentNode);
}

QVariant myModel::headerData(int section,
                                 Qt::Orientation orientation,
                                 int role) const
{
    if (orientation == Qt::Horizontal && role == Qt::DisplayRole) {
        if (section == 0) {
            return tr("Node");
        } else if (section == 1) {
            return tr("Value");
        }
    }
    return QVariant();
}

CSharedV *myModel::nodeFromIndex(const QModelIndex &index) const
{
    if (index.isValid()) {
        return static_cast<CSharedV *>(index.internalPointer());
    } else {
        return rootNode;
    }
}

CSharedV *myModel::childFromParent(const CSharedV *parent, int row) const
{
	if (parent && row >= 0 && row < parent->propCount()) {
		QHash<QString,CSharedV*>::const_iterator it = parent->propBegin();
		it += row;
		return it.value();
    } else {
        return 0;
    }
}