
#ifndef __my__
#define __my__

#include <QString>
#include <QHash>
#include <QLinkedList>
#include <QDataStream>

// Shared type
enum SharedType
{
	stUndefined,
	stInt,
	stFloat,
	stString,
	stObject
};


class CSharedV
{
public:
	// Construction
	CSharedV();
	~CSharedV();
	
	// System information
	inline QString getName() const { return m_sName; }
	inline SharedType getType() const { return m_nType; }
	inline const CSharedV * getOwner() const { return m_pOwner; }
	inline CSharedV * getOwner() { return m_pOwner; }
	QString asDebugString() const;
	
	// Simple data access
	inline int asInt() const { Q_ASSERT( getType() == stInt ); return m_nIntValue; }
	inline float asFloat() const { Q_ASSERT( getType() == stFloat ); return m_fFloatValue; }
	inline QString asString() const { Q_ASSERT( getType() == stString ); return m_sStringValue; }
		
	// Properties iterators
	inline QHash<QString,CSharedV*>::iterator propBegin() { return m_Properties.begin(); }
	inline QHash<QString,CSharedV*>::const_iterator propBegin() const { return m_Properties.begin(); }
	inline QHash<QString,CSharedV*>::iterator propEnd() { return m_Properties.end(); }
	inline QHash<QString,CSharedV*>::const_iterator propEnd() const { return m_Properties.end(); }
	
	inline int propCount() const { return m_Properties.count(); }
	int indexOf(const CSharedV *v) const;

public:	
	void change( int nID, bool bMultiChange );
	
	int	    m_nIntValue;
	float   m_fFloatValue;
	QString m_sStringValue;
	
	QHash<QString,CSharedV*> m_Properties;
	
	QString          m_sName;
	SharedType       m_nType;
	CSharedV * m_pOwner;
};

#endif // __my__
